local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

aom_fire = {}


function aom_fire.spread(pos, node)
  aom_util.did_abm("fire")
  if not node then node = core.get_node(pos) end
  if math.random() < 0.1 then -- random chance to go out
    core.dig_node(pos)
    return nil
  end
  local nodes = core.find_nodes_in_area_under_air(
    vector.offset(pos, -1, -1, -1),
    vector.offset(pos,  1,  2,  1),
    {"group:flammable"})
  local spread_pos = nil
  for noderef, value in pairs(nodes) do
    if true then
      spread_pos = value
      break
    end
  end
  if not spread_pos then
    return false
  end
  spread_pos = vector.offset(spread_pos, 0, 1, 0)
  if core.get_node(spread_pos).name == "air" then
    core.set_node(spread_pos, {name=node.name})
  end
end

function aom_fire.burn_up_node(pos)
  aom_util.did_abm("fire")
  if math.random() > 0.8 then return end
  local below = core.get_node(vector.offset(pos, 0, -1, 0))
  local is_above_flammable = (core.get_item_group(below.name, "flammable") ~= 0)
  if not is_above_flammable then
    core.dig_node(pos)
  elseif is_above_flammable then
    if below.name == "aom_wood:hot_coals" then
      core.dig_node(pos)
      if math.random() < 0.1 then
        local above = core.get_node_or_nil(vector.offset(pos, 0, 1, 0))
        if above and above.name ~= "air" then
          core.set_node(vector.offset(pos, 0, -1, 0), {name = "aom_fire:fire"})
        end
      end
    elseif core.get_item_group(below.name, "wood_log") == 0
    and below.name ~= "aom_wood:charcoal_block"
    and math.random() < 0.7 then
      core.set_node(vector.offset(pos, 0, -1, 0), {name = "aom_fire:fire"})
      core.dig_node(pos)
    elseif math.random() < 0.4 then
      core.set_node(vector.offset(pos, 0, -1, 0), {name = "aom_wood:hot_coals"}) -- aom_wood:charcoal_block
    end
  end
end


local fire_size = {
  type = "fixed",
  fixed = {-4/16, -8/16, -4/16, 4/16, 3/16, 4/16},}

core.register_node('aom_fire:fire', {
  -- TL: flames node
  description = S("Fire"),
  _tt_color = 6,
  groups = { item_fire = 1, nature = 1, dig_immediate = 1, fire = 1, lights_fires = 1, spreads_fire = 1, not_in_creative_inventory = 1, },
    drawtype = "mesh",
  use_texture_alpha = "clip",
    tiles = {{
            name = "aom_fire.png", -- this is the flame texture
            animation = {
                type = "vertical_frames",
                aspect_w = 16,
                aspect_h = 16,
                length = 0.5,
            },},},
  drop = "",
  selection_box = fire_size,
  walkable = false,
  damage_per_second = 4,
  buildable_to = true,
    mesh = "aom_fire.b3d",
  light_source = 12,
  paramtype = "light",
  sounds = (aom_sounds.default and aom_sounds.default_stone()),
    collision_box = nil,
  on_punch = function(pos, node, clicker, itemstack, pointed_thing)
    core.dig_node(pos)
  end,
  on_timer = function(pos, elapsed)
    aom_fire.spread(pos)
    aom_fire.burn_up_node(pos)
    if core.get_node(pos).name == "aom_fire:fire" then
      local nt = core.get_node_timer(pos)
      nt:start(math.random()*8 + 3)
    end
  end,
  on_construct = function(pos)
    local nt = core.get_node_timer(pos)
    nt:start(math.random()*8 + 3)
  end
})

-- spread fire
core.register_abm({
  nodenames = {"group:spreads_fire"},
  neighbors = {"group:flammable"},
  interval = 20.0,
  chance = 20,
  action = aom_fire.spread,
})

