local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)


core.register_entity("aom_machines:gear_lever_ENTITY", {
	initial_properties = {
		visual = "mesh",
		mesh = "aom_wire_gear_lever.b3d",
		textures = {"aom_wire_gear_lever.png"},
		use_texture_alpha = true,
		stepheight = 0,
		hp_max = 1,
		physical = false,
		pointable = false,
		static_save = false,
	},
	on_step = function(self, dtime)
		local pos = self.object:get_pos()
		if not pos then return end

		if self._ftimer ~= nil then
			self._ftimer = self._ftimer - dtime
			if self._ftimer > 0 then return
			else self._ftimer = self._ftimer + 0.1 end
			self._killframes = (self._killframes or 0) + 1
			local t = 255
			local tf = 4
			if self._killframes > tf then
				self.object:remove()
				return
			else
				self.object:set_properties({
					textures = {"aom_wire_gear_lever.png^[opacity:" .. tostring(t - t * (self._killframes / tf))},
				})
			end
		else
			local node = core.get_node(pos)
			if node.name ~= "aom_machines:gear_lever_pushed" then
				self._ftimer = 0
				return
			end
		end
		if not self._init then
			self._init = true
			self.object:set_animation({x=0,y=100}, 40, 0.1, false)
			return
		end
		self._age = (self._age or 0) + dtime
		if self._age > 10 then
			self.object:remove()
			return
		end
	end,
})



local function add_entity(pos)
	local node = core.get_node(pos)
	if node.name ~= "aom_machines:gear_lever_pushed" then return false end
	local dir = core.facedir_to_dir(node.param2)
	local yaw = core.dir_to_yaw(dir)
	local object = core.add_entity(pos, "aom_machines:gear_lever_ENTITY")
	if not object then return false end
	object:set_yaw(yaw-math.pi)
end

-- lever
core.register_node("aom_machines:gear_lever", {
	_original_name = "aom_machines:gear_lever",
	description = S("Gear Lever"),
	_tt_long_desc = S("Can be connected to inputs using wirecutters."),
	_tt_how_to_use = S("[place] to activate"),
	_tt_color = 2,
	tiles = {
		"aom_wire_gear_lever.png",
	},
	mesh = "aom_wire_gear_lever_node.obj",
	drawtype = "mesh",
	paramtype = "light",
	paramtype2 = "facedir",
	groups = { oddly_breakable_by_hand = 3, cracky = 1, mechanisms = 1, wire_output = 1, },
	on_place = function(itemstack, placer, pointed_thing)
		return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
	end,
	sounds = core.get_modpath("aom_sounds") and aom_sounds.default_stone() or nil,
	_aom_wire_activation_sound = {
		press = {
			name = "aom_gates_chain_pulley",
			gain = 0.2, pitch = 1.0, start_time = 0.3,
		},
	},
	-- hook into api
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
		local dir = pointed_thing.under - pointed_thing.above
		if not vector.equals(core.facedir_to_dir(node.param2), dir) and core.is_player(clicker) then
			core.sound_play("aom_not_allowed", {
				gain = 0.2,
				pitch = 1,
				to_player = clicker:get_player_name()
			})
			return
		end
		aom_wire.button.on_rightclick(pos, node, clicker, itemstack, pointed_thing)
		add_entity(pos)
	end,
	_aom_wire_unpress_time = 2.4,
})
-- lever
core.register_node("aom_machines:gear_lever_pushed", {
	_original_name = "aom_machines:gear_lever",
	tiles = {
		"aom_wire_gear_lever.png",
	},
	mesh = "aom_wire_gear_lever_node_empty.obj",
	drawtype = "mesh",
	paramtype = "light",
	paramtype2 = "facedir",
	drop = "aom_machines:gear_lever",
	sunlight_propagates = true,
	groups = { oddly_breakable_by_hand = 3, cracky = 1, not_in_creative_inventory = 1, },
	sounds = core.get_modpath("aom_sounds") and aom_sounds.default_stone() or nil,
	-- hook into api
	on_timer = aom_wire.button.on_timer_unpush,
	on_construct = function(pos)
		add_entity(pos)
	end,
	on_rightclick = function(...) end,
	_aom_wire_activation_sound = {},
})

if aom_machines.has_aom_tcraft then
	aom_tcraft.register_craft({
		output = "aom_machines:gear_lever",
		items = {
			["aom_items:stick"] = 1,
			["aom_items:iron_bar"] = 1,
			["aom_items:bronze_bar"] = 1,
		},
	})
end
