local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)

aom_mirecaves = {}
aom_mirecaves.max = 100
-- aom_mirecaves.max = aom_vars.overworld.sea_level - 30
aom_mirecaves.min = aom_vars.overworld.sea_level - 80

aom_mirecaves.biome_list = {"mirecaves"}

aom_mirecaves.mg_name = core.get_mapgen_setting("mg_name")

aom_mirecaves.has_aom_tcraft = core.get_modpath("aom_tcraft") ~= nil
function aom_mirecaves.register_craft(...)
	if aom_mirecaves.has_aom_tcraft then return aom_tcraft.register_craft(...) end
end
function aom_mirecaves.register_two_way_craft(a, b, c)
    if not c then c = 1 end
    aom_mirecaves.register_craft({output = b .. " " .. c, items = {[a] = c}})
    aom_mirecaves.register_craft({output = a .. " " .. c, items = {[b] = c}, hide_if_not_craftable = true})
end

-- util
dofile(mod_path .. "/utilities.lua")

-- nodes
dofile(mod_path .. "/nodes" .. "/stone.lua")
dofile(mod_path .. "/nodes" .. "/mirestone_bricks.lua")
dofile(mod_path .. "/nodes" .. "/nolmer.lua")
dofile(mod_path .. "/scripts" .. "/nolmer_growing.lua")
dofile(mod_path .. "/nodes" .. "/workaround.lua")

dofile(mod_path .. "/mapgen" .. "/biome.lua")
-- decor
dofile(mod_path .. "/mapgen" .. "/cleaner.lua")

if core.get_modpath("aom_mapgen") and core.get_modpath("aom_stone") then
    aom_stone.register_ores_for_node("aom_mirecaves:stone")
    aom_mapgen.register_ores_for_node("aom_mirecaves:stone", {
        skip = {
            coal = true,
        }
    })
end
