local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)


core.register_node("aom_mirecaves:mirestone_brick", {
    description = S("Mirestone Brick"),
    groups = { full_solid = 1, mirestone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {{name="aom_mirecaves_mirestone_brick.png", align_style="world", scale=4}},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_mirecaves:mirestone_brick")
aom_mirecaves.register_two_way_craft("aom_mirecaves:stone", "aom_mirecaves:mirestone_brick")


core.register_node("aom_mirecaves:mirestone_brick_fine", {
    description = S("Fine Mirestone Brick"),
    groups = { full_solid = 1, mirestone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {{name="aom_mirecaves_mirestone_brick_fine.png", align_style="world", scale=4}},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_mirecaves:mirestone_brick_fine")
aom_mirecaves.register_two_way_craft("aom_mirecaves:stone", "aom_mirecaves:mirestone_brick_fine")


core.register_node("aom_mirecaves:mirestone_brick_pillar", {
    description = S("Mirestone Brick Pillar"),
    groups = { full_solid = 1, mirestone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_mirecaves_mirestone_brick_pillar_top.png", "aom_mirecaves_mirestone_brick_pillar_top.png", "aom_mirecaves_mirestone_brick_pillar.png"},
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
aom_util.register_all_shapes("aom_mirecaves:mirestone_brick_pillar")
aom_mirecaves.register_two_way_craft("aom_mirecaves:stone", "aom_mirecaves:mirestone_brick_pillar")


core.register_node("aom_mirecaves:mirestone_brick_ornate", {
    description = S("Mirestone Brick Ornate"),
    groups = { full_solid = 1, mirestone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_mirecaves_mirestone_brick_ornate.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_mirecaves:mirestone_brick_ornate")
aom_mirecaves.register_two_way_craft("aom_mirecaves:stone", "aom_mirecaves:mirestone_brick_ornate")


core.register_node("aom_mirecaves:mirestone_brick_lamp", {
    description = S("Mirestone Brick Lamp"),
    groups = { full_solid = 1, mirestone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = aom_util.node_light_unfck("aom_mirecaves_mirestone_brick_lamp.png"),
    sounds = aom_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_mirecaves:mirestone_brick_lamp")
aom_mirecaves.register_craft({
    output = "aom_mirecaves:mirestone_brick_lamp",
    items = {
        ["aom_mirecaves:stone"] = 1,
        ["aom_lights:torch"] = 1,
    }
})
