

local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)


aom_underworld = {}


aom_underworld.alt_min = aom_vars.overworld.alt_min - 1000
aom_underworld.alt_max = aom_vars.overworld.alt_min
aom_underworld.sea_level = aom_underworld.alt_min + 70
aom_underworld.ore_multiplier = 1

aom_underworld.soil = 5
aom_underworld.topsoil = 2
aom_underworld.dust = 1
aom_underworld.ceiling = 3

aom_underworld.lava_rock_light = 1
aom_underworld.mythrite_light = 7

-- register underworld
aom_dimensions.register_dimension({
    name = "underworld",
    is_full_strata = true,
    min_y = aom_underworld.alt_min,
    max_y = aom_underworld.alt_max,
    sea_level = aom_underworld.sea_level,
    ore_multiplier = 1,
})

aom_underworld.has_aom_tcraft = core.get_modpath("aom_tcraft") ~= nil
function aom_underworld.register_craft(...)
	if aom_underworld.has_aom_tcraft then
		return aom_tcraft.register_craft(...)
	end
end

function aom_underworld.register_two_way_craft(a, b, c)
    if not c then c = 1 end
    aom_underworld.register_craft({
        output = b .. " " .. c, items = {[a] = c},
    })
    aom_underworld.register_craft({
        output = a .. " " .. c, items = {[b] = c}, hide_if_not_craftable = true,
    })
end

function aom_underworld.register_transmute(a, b, n, c)
    local ig = "aom_items:ignis"
    aom_underworld.register_craft({
        output = b .. " " .. n, items = {[a] = n, [ig] = c},
        tags = {"transmute"},
    })
    aom_underworld.register_craft({
        output = a .. " " .. n, items = {[b] = n, [ig] = c},
        hide_if_not_craftable = true, tags = {"transmute"},
    })
end

-- utilities
dofile(mod_path .. "/utilities.lua")


-- nodes
dofile(mod_path .. "/nodes" .. "/glow_rock.lua")
dofile(mod_path .. "/nodes" .. "/lava_coral.lua")
dofile(mod_path .. "/nodes" .. "/lava_rock.lua")
dofile(mod_path .. "/nodes" .. "/lava_brick.lua")
dofile(mod_path .. "/nodes" .. "/soils.lua")
dofile(mod_path .. "/nodes" .. "/ores.lua")
dofile(mod_path .. "/nodes" .. "/mythrite.lua")
dofile(mod_path .. "/nodes" .. "/fog.lua")
dofile(mod_path .. "/nodes" .. "/arlior.lua")
dofile(mod_path .. "/nodes" .. "/arlior_plants.lua")
dofile(mod_path .. "/nodes" .. "/arlior_brick.lua")
dofile(mod_path .. "/nodes" .. "/arlior_growth.lua")
dofile(mod_path .. "/nodes" .. "/worknodes.lua")

-- items
dofile(mod_path .. "/items" .. "/craftitems.lua")
dofile(mod_path .. "/items" .. "/tools.lua")
dofile(mod_path .. "/items" .. "/cortite_sceptre.lua")
if aom_hammer ~= nil then dofile(mod_path .. "/items" .. "/hammer.lua") end

-- mobs
dofile(mod_path .. "/mobs" .. "/coral_bug.lua")

-- mapgen
dofile(mod_path .. "/mapgen" .. "/biomes.lua")
dofile(mod_path .. "/mapgen" .. "/scripts" .. "/caverns.lua")
dofile(mod_path .. "/mapgen" .. "/scripts" .. "/columns.lua")
dofile(mod_path .. "/mapgen" .. "/scripts" .. "/overworld_blend.lua")
dofile(mod_path .. "/mapgen" .. "/scripts" .. "/base_terrain.lua")
dofile(mod_path .. "/mapgen" .. "/soils.lua")

-- do this after everything else in mapgen so you know which nodes are topsoil and which are ceiling
dofile(mod_path .. "/mapgen" .. "/scripts" .. "/cleaner.lua")

-- do decorations and ores last
dofile(mod_path .. "/mapgen" .. "/decorations.lua")
dofile(mod_path .. "/mapgen" .. "/ore.lua")

aom_underworld.register_transmute("aom_underworld:arlior", "aom_underworld:arlioran", 10, 1)
aom_underworld.register_transmute("aom_underworld:lava_rock", "aom_underworld:arlior", 10, 1)
aom_underworld.register_transmute("aom_underworld:lava_rock", "aom_underworld:lava_coral", 10, 1)
