local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

local uses

local enable_durability = core.settings:get("aom_tool_durability") == true

uses = 2048*2
local idef = core.registered_tools["aom_hammer:iron_hammer"] or {}
core.register_tool("aom_underworld:mythril_hammer", {
    description = S("Mythril Hammer"),
    _tt_color = 2,
    inventory_image = "aom_underworld_mythril_hammer.png",
    _tt_long_desc = idef._tt_long_desc,
    _tt_how_to_use = idef._tt_how_to_use,
    -- _tt_uses = uses,
    tool_capabilities = {
        full_punch_interval = 2,
        groupcaps = {
            cracky = {
                maxlevel = 5,
                uses = ((not enable_durability) and 0) or uses,
            },
            crumbly = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            choppy = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            snappy = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            magicky = {
                maxlevel = 2,
                uses = ((not enable_durability) and 0) or uses,
            },
            dig_immediate = {
                maxlevel = 8,
                uses = ((not enable_durability) and 0) or uses,
            },
        },
        damage_groups = {
            blunt=5,
        },
    },
    groups = { hammer = 3 },
    on_place = aom_hammer.get_paint_node_from_pointed,
    on_use = aom_hammer.paint_node,
    _on_step = aom_hammer.paint_node_on_step,
})
if true then
    local m = "aom_underworld:cortite_rod"
    local b = "aom_underworld:mythril"
    core.register_craft({
        output = "aom_underworld:mythril_hammer",
        recipe = {
        {b, m, b},
        {"",m,""},
        {"",m,""},
        },
    })
end
