


local vmax = aom_underworld.alt_max
local vmin = aom_underworld.alt_min



-- core.set_mapgen_params("flags", {dungeon = false}, true)

-- replace everything with lava rock to clear caves
core.register_ore({
  ore_type       = "stratum",
  ore            = "aom_underworld:lava_rock",
  wherein        = {"air", "group:solid", "group:liquid"},
  y_min = vmin,
  y_max = vmax,
})

-- replace everything with lava rock
core.register_ore({
  ore_type       = "stratum",
  ore            = "aom_underworld:lava_rock",
  wherein        = {"group:solid", "group:liquid"},
  y_min = aom_underworld.alt_min,
  y_max = aom_underworld.alt_max,
})


local size = 1300
local c = math.floor(math.abs(vmax - vmin)/120)
local thickness = 30
local craziness = 20
local base_thickness = 100
local scale = 100
-- local i = 1
for i=0, c-2 do
  ---------------------------------------------------------
  -- caverns
  ---------------------------------------------------------
  core.register_ore({
    ore_type       = "stratum",
    ore            = "air",
    wherein        = {"group:solid", "group:liquid", "group:stone"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + base_thickness,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559 + i*137,
      octaves = 5 + (i<=1 and 2 or 0),
    },
    np_stratum_thickness = {
      offset = thickness + ((i<=1 and 30) or 0) - i * 1,
      scale = craziness - i * 5,
      spread = {x = 100, y = 100, z = 100},
      seed = 8976 + i * 276,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
  ---------------------------------------------------------
  -- ceiling
  ---------------------------------------------------------
  core.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_ceiling",
    wherein        = {"group:solid", "group:liquid", "group:stone"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + base_thickness + aom_underworld.ceiling,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559 + i*137,
      octaves = 5 + (i<=1 and 2 or 0),
    },
    np_stratum_thickness = {
      offset = thickness + ((i<=1 and 30) or 0) - i * 1,
      scale = craziness - i * 5,
      spread = {x = 100, y = 100, z = 100},
      seed = 8976 + i * 276,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
  ---------------------------------------------------------
  -- soil layer (thick)
  ---------------------------------------------------------
  core.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_soil",
    wherein        = {"group:solid", "group:liquid", "group:stone"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + base_thickness - aom_underworld.soil,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559 + i*137,
      octaves = 5 + (i<=1 and 2 or 0),
    },
    np_stratum_thickness = {
      offset = thickness + ((i<=1 and 30) or 0) - i * 1,
      scale = craziness - i * 5,
      spread = {x = 100, y = 100, z = 100},
      seed = 8976 + i * 276,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
  ---------------------------------------------------------
  -- topsoil single node layer
  ---------------------------------------------------------
  core.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_topsoil",
    wherein        = {"aom_underworld:worknode_soil"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + base_thickness - aom_underworld.topsoil,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559 + i*137,
      octaves = 5 + (i<=1 and 2 or 0),
    },
    np_stratum_thickness = {
      offset = thickness + ((i<=1 and 30) or 0) - i * 1,
      scale = craziness - i * 5,
      spread = {x = 100, y = 100, z = 100},
      seed = 8976 + i * 276,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
  ---------------------------------------------------------
  -- dust single node layer
  ---------------------------------------------------------
  core.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_dust",
    wherein        = {"aom_underworld:worknode_topsoil"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + base_thickness - aom_underworld.dust,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559 + i*137,
      octaves = 5 + (i<=1 and 2 or 0),
    },
    np_stratum_thickness = {
      offset = thickness + ((i<=1 and 30) or 0) - i * 1,
      scale = craziness - i * 5,
      spread = {x = 100, y = 100, z = 100},
      seed = 8976 + i * 276,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
end
