local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)

local vmax = aom_underworld.alt_max
local vmin = aom_underworld.alt_min


local c = math.floor(math.abs(vmax - vmin)/200)
-- local i = 1
for i=1, c do
  local sizeash = 700
  core.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:ash",
    wherein        = {"aom_underworld:worknode_topsoil"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + vmax / 2,
      scale = 900,
      spread = {x = sizeash, y = sizeash, z = sizeash},
      seed = 36343,
      octaves = 6,
    },
    np_stratum_thickness = {
      offset = -200,
      scale = 700,
      spread = {x = 100, y = 100, z = 100},
      seed = 32,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {"underworld", "underworld_bridges"},
  })
end

core.register_ore({
  ore_type       = "stratum",
  ore            = "aom_underworld:glow_rock",
  wherein        = {"aom_underworld:worknode_topsoil"},
  y_min = vmin,
  y_max = vmax,
  clust_scarcity  = 1,
  noise_params    = {
      offset = vmin + vmax / 2,
      scale = 900,
      spread = {x = 100, y = 100, z = 100},
      seed = 890,
      octaves = 5,
  },
  np_stratum_thickness = {
      offset = 5,
      scale = 200,
      spread = {x = 90, y = 90, z = 90},
      seed = 324,
      octaves = 3,
      persistence = 0.7
  },
  stratum_thickness = 20,
  biomes = {"underworld", "underworld_coral", "underworld_bridges"},
})

core.register_ore({
  ore_type       = "stratum",
  ore            = "aom_underworld:lava_rock",
  wherein        = {"aom_underworld:workaround_node"},
  y_min = vmin,
  y_max = vmax,
})




-- biome soil lists
dofile(mod_path .. "/mapgen" .. "/biome_soils" .. "/underworld_coral.lua")
dofile(mod_path .. "/mapgen" .. "/biome_soils" .. "/arlior_meadow.lua")
dofile(mod_path .. "/mapgen" .. "/biome_soils" .. "/arlior_growth.lua")
