local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

core.register_node("aom_underworld:mythrite", {
    description = S("Mythrite"),
    _tt_long_desc = S("Looking at it makes you feel nostalgic for some reason."),
    _tt_color = 3,
    groups = {
        full_solid = 1, material_mythrite = 1, underworld = 1,
        oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2,
    },
    tiles = {"aom_underworld_mythrite.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.mythrite_light,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:mythrite")
aom_underworld.register_craft({
    output = "aom_underworld:mythrite 10",
    items = {
        ["aom_underworld:lava_rock"] = 10,
        ["aom_underworld:mythril_strand"] = 1,
    },
})

core.register_node('aom_underworld:mythrite_brick', {
    description = S("Mythrite Bricks"),
    _tt_color = 3,
    groups = {
        full_solid = 1, material_mythrite = 1, underworld = 1,
        oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2,
    },
    tiles = {"aom_underworld_mythrite_brick.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.mythrite_light,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:mythrite_brick")
aom_underworld.register_two_way_craft("aom_underworld:mythrite", "aom_underworld:mythrite_brick")


core.register_node('aom_underworld:mythrite_lamp', {
    description = S("Mythrite Lamp"),
    _tt_color = 3,
    groups = {
        full_solid = 1, material_mythrite_lamp = 1, underworld = 1,
        oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2,
    },
    tiles = {"aom_underworld_mythrite_lamp.png"},
    sounds = aom_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:mythrite_lamp")
aom_underworld.register_two_way_craft("aom_underworld:mythrite", "aom_underworld:mythrite_lamp")

core.register_node('aom_underworld:mythrite_brick_fine', {
    description = S("Fine Mythrite Bricks"),
    groups = {
        full_solid = 1, material_mythrite = 1, underworld = 1,
        oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2,
    },
    tiles = {"aom_underworld_mythrite_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.mythrite_light,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:mythrite_brick_fine")
aom_underworld.register_two_way_craft("aom_underworld:mythrite", "aom_underworld:mythrite_brick_fine")


core.register_node('aom_underworld:mythrite_brick_pillar', {
    description = S("Mythrite Brick Pillar"),
    _tt_color = 3,
    groups = {
        full_solid = 1, material_mythrite = 1, oddly_breakable_by_hand = 3,
        magicky = 1, solid = 1, suffocates = 2,
    },
    tiles = {"aom_underworld_mythrite_brick_pillar_top.png", "aom_underworld_mythrite_brick_pillar_top.png", "aom_underworld_mythrite_brick_pillar.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.mythrite_light,
    paramtype = "light",
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
aom_util.register_all_shapes("aom_underworld:mythrite_brick_pillar")
aom_underworld.register_two_way_craft("aom_underworld:mythrite", "aom_underworld:mythrite_brick_pillar")
