
---@class InTimer
ExtraClasses.InTimer = {
	time = 0,
	interval = 1,
}

---True if interval has passed this tick.
---@param self InTimer
---@param dtime number
---@return boolean
function ExtraClasses.InTimer.on_timer(self, dtime)
	self.time = self.time + dtime
	if self.time >= self.interval then
		self.time = self.time - self.interval
		return true
	end
	return false
end

ExtraClasses.InTimer.__meta = {
	__index = ExtraClasses.InTimer,
}

---@param interval number
---@param time number|nil
---@return InTimer
function ExtraClasses.InTimer.new(interval, time)
	local o = setmetatable({}, ExtraClasses.InTimer.__meta)
	o.interval = interval
	o.time = time or 0
	return o
end
