
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "desert_dunes"
local biomes_all = {
	this_biome,
	this_biome.."_OCEAN",
	this_biome.."_underground",
}
local biomes_underground = {
	this_biome.."_OCEAN",
	this_biome.."_underground",
}

aom_mapgen.register_biome({
    name = this_biome,

    node_top = "aom_soil:sand",
    depth_top = 5,

    -- node_dust = "aom_soil:clay",
    -- depth_dust = 1,

    node_filler = "aom_stone:sandstone",
    depth_filler = 15,

    node_riverbed = "aom_soil:sand",
    depth_riverbed = 3,

    node_stone = "aom_stone:sandstone",

    y_max = sealevel + 40,
    y_min = sealevel - 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 100,
    humidity_point = 0,
}, {"desert", "overworld"})

aom_mapgen.register_biome({
	name = this_biome.."_underground",

    node_stone = "aom_stone:sandstone",

	y_max = sealevel - 80,
	y_min = alt_min,
	vertical_blend = 8,

    heat_point = core.registered_biomes[this_biome].heat_point,
    humidity_point = core.registered_biomes[this_biome].humidity_point,

	_wind_multiplier = 0,
}, {"desert", "overworld", "underground"})

local sch = aom_sch.get_schematic_path

-------------------------------
--------- DECORATIONS ---------
-------------------------------

core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:sand"},
    sidelen = 80,
    noise_params = {
        offset    = 0,
        scale     = 0.0001,
        spread    = {x=3, y=3, z=3},
        seed      = 7852,
        octaves   = 4,
        persist   = 1,
        lacunarity= 1,
        flags = "defaults",
    },
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("aom_boulder_0"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:sand"},
    sidelen = 80,
    noise_params = {
        offset    = 0,
        scale     = 0.0001,
        spread    = {x=3, y=3, z=3},
        seed      = 87,
        octaves   = 4,
        persist   = 1,
        lacunarity= 1,
        flags = "defaults",
    },
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("aom_boulder_1"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:sand"},
    sidelen = 80,
    noise_params = {
        offset    = 0,
        scale     = 0.0001,
        spread    = {x=3, y=3, z=3},
        seed      = 7852,
        octaves   = 4,
        persist   = 1,
        lacunarity= 1,
        flags = "defaults",
    },
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("aom_boulder_2"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})

core.register_decoration({
	deco_type = "simple",
	place_on = {
        "aom_stone:cobble_moss_1", "aom_stone:cobble_moss_2",
        "aom_stone:stone", "aom_stone:cobble",
    },
	sidelen = 4,
	noise_params = {
		offset = -0.2,
		scale = 0.5,
		spread = {x = 16, y = 16, z = 16},
		seed = 7534,
		octaves = 4,
		persist = 0.2,
		lacunarity = 2.00,
	},
	biomes = biomes_underground,
	y_max = alt_max,
	y_min = alt_min,
	decoration = "aom_spawnnodes:mossy_rubble",
    flags = "all_floors",
    _layer = 47,
})






core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_stone:sandstone"},
	decoration = "aom_soil:sand",

    fill_ratio = 100,
	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -3,
	height = 3,
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_soil:sand"},
	decoration = "aom_stone:sandstone",

    fill_ratio = 100,
	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -3,
	height = 1,
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_soil:sand"},
	decoration = "aom_soil:gravel",

	biomes = biomes_underground,
	y_max = alt_max,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -2,
	height = 2,

	sidelen = 4,
	noise_params = {
		offset = -1.5,
		scale = 6.0,
		spread = {x = 16, y = 8, z = 16},
		seed = 5423,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"aom_soil:gravel"},
    decoration = {
        "aom_flora:mushroom_glow_yellow_0", "aom_flora:mushroom_glow_yellow_1",
    },

    noise_params = {
        offset = -0.1,
        scale = 0.3,
        spread = {x = 28, y = 8, z = 28},
        seed = 8765,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.7149
    },
    biomes = biomes_underground,
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})
