
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "hem_forest"
local biomes_all = {
	this_biome,
	this_biome.."_OCEAN",
	this_biome.."_underground",
}
local biomes_underground = {
	this_biome.."_OCEAN",
	this_biome.."_underground",
}

local node_top = "aom_soil:gravel"
local fill = "aom_soil:dirt"
local node_tree_dirt = "aom_soil:forest_grass_3"
local node_tree_dirt2 = "aom_soil:forest_grass_4"
local node_grass = "aom_soil:grass_variant_4"

aom_mapgen.register_biome({
	name = this_biome,

	node_top = node_top,
	depth_top = 1,

	node_filler = fill,
	depth_filler = 5,

	node_riverbed = "aom_soil:sand",
	depth_riverbed = 3,

	y_max = sealevel + 120,
	y_min = sealevel + 1,
	y_min_ocean = sealevel - 80,
	vertical_blend = 1,

	heat_point = 89,
	humidity_point = 74,

	_wind_multiplier = 0,
}, {"forest", "hem", "overworld", "flowers", "grass", "mushrooms_dense"})

aom_mapgen.register_biome({
	name = this_biome.."_underground",

	y_max = sealevel - 80,
	y_min = alt_min,
	vertical_blend = 8,

	heat_point = 89,
	humidity_point = 74,

	_wind_multiplier = 0,
}, {"forest", "hem", "overworld", "underground", "grass", "mushrooms"})


-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

aom_mapgen.add_boulders({
	biomes = {this_biome},
	place_on = {"group:soil", "group:stone"},
	chance = 1,
	height_offset = 0,
	np = {
		offset = -0.015,
		scale = 0.02,
		spread = {x = 10, y = 10, z = 10},
		seed = 123,
		octaves = 3,
		persistence = 0.7,
		lacunarity = 1.7,
	},
})
local size = 40
local off = 60
local sca = 100
core.register_ore({
	ore_type	= "stratum",
	ore		    = node_tree_dirt,
	wherein		= {node_top},
	y_min = sealevel-20,
	y_max = sealevel+200,
	clust_scarcity    = 1,
	noise_params        = {
			offset = sealevel+10,
			scale = 100,
			spread = {x = size, y = size, z = size},
			seed = 34,
			octaves = 2,
	},
	np_stratum_thickness = {
			offset = off,
			scale = sca,
			spread = {x = size/2, y = size/2, z = size/2},
			seed = 4563,
			octaves = 3,
			persistence = 0.2
	},
	stratum_thickness = 20,
	biomes = {this_biome},
})

core.register_ore({
	ore_type	= "stratum",
	ore		    = node_grass,
	wherein		= {node_top},
	y_min = sealevel-20,
	y_max = sealevel+200,
	clust_scarcity    = 1,
	noise_params        = {
			offset = sealevel+10,
			scale = 50,
			spread = {x = size, y = size, z = size},
			seed = 34,
			octaves = 2,
	},
	np_stratum_thickness = {
			offset = off+20,
			scale = sca,
			spread = {x = size/2, y = size/2, z = size/2},
			seed = 4563,
			octaves = 3,
			persistence = 0.2
	},
	stratum_thickness = 20,
	biomes = {this_biome},
})

core.register_ore({
	ore_type	= "stratum",
	ore		    = node_tree_dirt2,
	wherein		= {node_tree_dirt},
	y_min = sealevel-20,
	y_max = sealevel+200,
	clust_scarcity    = 1,
	noise_params        = {
			offset = sealevel+10,
			scale = 100,
			spread = {x = size, y = size, z = size},
			seed = 6543,
			octaves = 2,
	},
	np_stratum_thickness = {
			offset = off,
			scale = sca,
			spread = {x = size/2, y = size/2, z = size/2},
			seed = 23,
			octaves = 3,
			persistence = 0.2
	},
	stratum_thickness = 20,
	biomes = {this_biome},
})

-----------
---POOLS---
-----------

for i = 2, 0, -1 do
	core.register_decoration({
		deco_type = "schematic",
		place_on = {"group:solid"},
		sidelen = 16,
		fill_ratio = 0.001,
		biomes = {this_biome},
		y_max = alt_max,
		y_min = alt_min,
		schematic = sch("aom_hem_pool_" .. i),
		flags = "place_center_x, place_center_z, force_placement, all_floors",
		rotation = "random",
		place_offset_y = -6,
		_layer = 15,
	})
end

-----------
-- TREES --
-----------

for i, item in ipairs({
	{name="aom_tree_hem_h15_0", layer=35},
	{name="aom_tree_hem_h12_0", layer=35},
	{name="aom_tree_hem_h9_0", layer=36},
}) do
	core.register_decoration({
		deco_type = "schematic",
		place_on = {node_tree_dirt},
		sidelen = 16,
		fill_ratio = 0.006,
		biomes = {this_biome},
		y_max = alt_max,
		y_min = sealevel,
		schematic = sch(item.name),
		flags = "place_center_x, place_center_z",
		rotation = "random",
		_layer = item.layer,
	})
end

for i, item in ipairs({
	{name="aom_tree_hem_renner_h10_0", layer=35},
	{name="aom_tree_hem_renner_h9_0", layer=36},
}) do
	core.register_decoration({
		deco_type = "schematic",
		place_on = {node_tree_dirt2},
		sidelen = 4,
		fill_ratio = 0.006,
		biomes = {this_biome},
		y_max = alt_max,
		y_min = sealevel,
		schematic = sch(item.name),
		flags = "place_center_x, place_center_z",
		rotation = "random",
		_layer = item.layer,
	})
end


-- bushes
core.register_decoration({
	deco_type = "schematic",
	place_on = {node_grass},
	sidelen = 8,
	-- fill_ratio = 0.006,
	biomes = {this_biome},
	noise_params = {
		offset = -0.15,
		scale = 0.2,
		spread = {x = 10, y = 10, z = 10},
		seed = 453,
		octaves = 8,
		persistence = 0.7,
		lacunarity = 2.0,
	},
	y_max = alt_max,
	y_min = sealevel,
	schematic = sch("aom_tree_ash_bush_0"),
	flags = "place_center_x, place_center_z",
	rotation = "random",
	place_offset_y = 1,
    _layer = 39,
})

-- bushes
core.register_decoration({
	deco_type = "schematic",
	place_on = {node_grass},
	sidelen = 8,
	-- fill_ratio = 0.006,
	biomes = biomes_all,
	noise_params = {
		offset = -0.15,
		scale = 0.2,
		spread = {x = 10, y = 10, z = 10},
		seed = 6323,
		octaves = 8,
		persistence = 0.7,
		lacunarity = 2.0,
	},
	y_max = alt_max,
	y_min = alt_min,
	schematic = sch("aom_tree_hem_bush_0"),
	flags = "place_center_x, place_center_z, all_floors",
	rotation = "random",
	place_offset_y = 1,
    _layer = 39,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {"group:topsoil"},
	sidelen = 4,
	noise_params = {
		offset = -0.5,
		scale = 0.8,
		spread = {x = 8, y = 8, z = 8},
		seed = 65341,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
	biomes = biomes_all,
	y_max = alt_max,
	y_min = alt_min,
	decoration = "aom_spawnnodes:freshly_dug_holes",
	flags = "all_floors",
    _layer = 47,
})

local function do_aelum_grass_stuff(num, seed, offset)
	core.register_decoration({
		deco_type = "simple",
		place_on = {"aom_soil:gravel"},
		-- place_on = {tree_dirt},
		sidelen = 4,
		noise_params = {
			offset = -0.4 + (offset or 0),
			scale = 0.8,
			spread = {x = 8, y = 8, z = 8},
			seed = seed,
			octaves = 2,
			persist = 0.8,
			lacunarity = 2.00,
		},
		biomes = biomes_all,
		y_max = alt_max+1,
		y_min = alt_min,
		decoration = "aom_flora:aelum_grass_" .. num,
		flags = "all_floors",
		_layer = 46,
	})
end

do_aelum_grass_stuff(2, 5546, -0.01)
do_aelum_grass_stuff(1, 5546, 0.04)
do_aelum_grass_stuff(0, 5546, 0.09)

-- caves
core.register_decoration({
	deco_type = "schematic",
	place_on = {"group:stone"},
	sidelen = 2,
	-- fill_ratio = 0.006,
	biomes = biomes_underground,
	noise_params = {
		offset = -0.05,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 6323,
		octaves = 8,
		persistence = 0.7,
		lacunarity = 2.0,
	},
	y_max = sealevel-10,
	y_min = alt_min,
	schematic = sch("aom_cave_small_0"),
	flags = "place_center_x, place_center_z, all_floors, force_placement",
	rotation = "random",
	place_offset_y = 0,
    _layer = 4,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_stone:stone", "aom_stone:cobble", "group:solid"},
	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
	decoration = "aom_soil:dirt",
    flags = "all_floors, force_placement",
    place_offset_y = -3,
    fill_ratio = 100,
	height = 3,
    _layer = 5,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_soil:dirt"},
	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
	decoration = node_tree_dirt,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
    fill_ratio = 100,
	height = 1,
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {node_tree_dirt},
	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
	decoration = node_tree_dirt2,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
    -- fill_ratio = 0,
	height = 1,

	sidelen = 4,
	noise_params = {
		offset = -1.0,
		scale = 3.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 45213,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {node_tree_dirt},
	decoration = node_grass,

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
    -- fill_ratio = 0,
	height = 1,

	sidelen = 4,
	noise_params = {
		offset = -1.0,
		scale = 3.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 785,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {node_tree_dirt, node_tree_dirt2},
	decoration = node_top,

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
    -- fill_ratio = 0,
	height = 1,

	sidelen = 8,
	noise_params = {
		offset = -0.0,
		scale = 3.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 3421,
		octaves = 3,
		persist = 0.5,
		lacunarity = 2.00,
	},
    _layer = 6,
})


core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_stone:stone"},
	decoration = "aom_mirecaves:nolmera_vine_1",

	sidelen = 8,
	height = 1,
	height_max = 4,
	noise_params = {
		offset = 0.02,
		scale = 0.07,
		spread = {x = 4, y = 4, z = 4},
		seed = 8575,
		octaves = 1,
		persist = 0.1
	},
	y_max = alt_max,
	y_min = alt_min,
	flags = "all_ceilings",
	biomes = biomes_underground,
	_layer = 47,
})
core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_stone:stone"},
	decoration = "aom_mirecaves:nolmera_vine_1",

	sidelen = 4,
	height = 1,
	height_max = 9,
	noise_params = {
		offset = -0.08,
		scale = 0.3,
		spread = {x = 8, y = 2, z = 8},
		seed = 45245,
		octaves = 1,
		persist = 0.1
	},
	y_max = alt_max,
	y_min = alt_min,
	flags = "all_ceilings",
	biomes = biomes_underground,
	_layer = 47,
})
