
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "siera"
local these_biomes = {this_biome.."_plains", this_biome.."_mountains"}

-- PLAINS
aom_mapgen.register_biome({
    name = these_biomes[1],

    node_top = "aom_soil:grass",
    depth_top = 1,

    node_filler = "aom_soil:dirt",
    depth_filler = 5,

    node_riverbed = "aom_soil:sand",
    depth_riverbed = 3,

    y_max = sealevel + 30,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 20,

    heat_point = 100,
    humidity_point = 40,
}, {"forest", "ash", "overworld", "flowers", "grass"})
-- MOUNTAINS
aom_mapgen.register_biome({
    name = these_biomes[2],

    node_top = "aom_soil:grass",
    depth_top = 1,

    node_filler = "aom_soil:dirt",
    depth_filler = 5,

    node_riverbed = "aom_soil:sand",
    depth_riverbed = 3,

    y_max = alt_max,
    y_min = sealevel + 31,
    -- y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 100,
    humidity_point = 40,
}, {"forest", "ash", "overworld"})

if core.get_modpath("aom_weather") then
    for i, biome in ipairs(these_biomes) do
        aom_weather.allow_biome_weathers(biome, {
            "light_rain",
            "heavy_rain",
            "snow",
            "heavy_snow",
        }, false)
    end
    -- core.log("adding weathers")
end

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

aom_mapgen.add_boulders({
    biomes = these_biomes,
    place_on = {"group:soil", "group:stone"},
    chance = 1,
    height_offset = 0,
    np = {
        offset = -0.015,
        scale = 0.02,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 1.7,
    },
})

-- //////////////
-- SIERA STRUCTURES
-- //////////////

local np_structure = {
    offset = -0.019,
    scale = 0.017,
    spread = {x = 40, y = 40, z = 40},
    seed = 6875,
    octaves = 4,
    persistence = 0.7,
    lacunarity = 2.1,
}


-- ruin
np_structure.offset = -0.0000
np_structure.scale = 0.0010
for i = 0, 0 do
    for k = 0, 1 do
        core.register_decoration({
            deco_type = "schematic",
            place_on = {"group:soil", "group:stone"},
            sidelen = 16,
            biomes = these_biomes,
            noise_params = np_structure,
            y_max = alt_max,
            y_min = sealevel,
            schematic = sch("aom_siera_ruin_"..tostring(i)),
            flags = "place_center_x, place_center_z, force_placement",
            rotation = "random",
            place_offset_y = -17 + k * 2,
            _layer = 25,
        })
    end
end
-- TOWERS
np_structure.offset = -0.000
np_structure.scale = 0.001
for i = 0, 1 do
    for k = 1, 3 do
        core.register_decoration({
            deco_type = "schematic",
            place_on = {"group:soil", "group:stone"},
            sidelen = 16,
            biomes = these_biomes,
            noise_params = np_structure,
            y_max = alt_max,
            y_min = sealevel,
            schematic = sch("aom_siera_tower_ruin_"..tostring(i)),
            flags = "place_center_x, place_center_z, force_placement",
            rotation = "random",
            place_offset_y = -25 + k * 4,
            _layer = 25,
        })
    end
end

np_structure.offset = -0.013
np_structure.scale = 0.010
for i = 1, 3 do
    -- np_structure.seed = np_structure.seed + 1
    for k = 1, 3 do
        core.register_decoration({
            deco_type = "schematic",
            place_on = {"group:soil", "group:stone"},
            sidelen = 16,
            biomes = these_biomes,
            noise_params = np_structure,
            y_max = alt_max,
            y_min = sealevel,
            schematic = sch("aom_siera_tower_"..tostring(i)),
            flags = "place_center_x, place_center_z, force_placement",
            rotation = "random",
            place_offset_y = -25 + k * 4,
            _layer = 25,
        })
    end
end

-- GIANT ash
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = {
        offset = -0.015,
        scale = 0.0385,
        spread = {x = 100, y = 100, z = 100},
        seed = 64758,
        octaves = 5,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 34,
})


-- ash 2
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    -- fill_ratio = 0.001,
    noise_params = {
        offset = -0.004,
        scale = 0.0075,
        spread = {x = 20, y = 20, z = 20},
        seed = 71,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 1.0,
    },
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h18_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 34,
})

-- ash
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    fill_ratio = 0.0006,
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h12_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})

for i, item in ipairs({
	{name="aom_tree_oak_h14_0", layer=35},
	{name="aom_tree_oak_h12_1", layer=35},
	{name="aom_tree_oak_h10_0", layer=36},
}) do
    -- also do some OAK trees
    core.register_decoration({
        deco_type = "schematic",
        place_on = {"group:soil"},
        sidelen = 8,
        noise_params = {
            offset = -0.0025,
            scale = 0.008,
            spread = {x = 10, y = 10, z = 10},
            seed = 73355,
            octaves = 3,
            persistence = 0.2,
            lacunarity = 2.0,
        },
        biomes = these_biomes,
        y_max = alt_max,
        y_min = sealevel,
        schematic = sch(item.name),
        flags = "place_center_x, place_center_z",
        rotation = "random",
        place_offset_y = -0,
        _layer = item.layer,
    })
end

for i, item in ipairs({
    {name="aom_tree_oak_h23_0", layer=34},
    {name="aom_tree_oak_h19_0", layer=34},
    {name="aom_tree_oak_h12_1", layer=35},
}) do
    -- also do some OAK trees
    core.register_decoration({
        deco_type = "schematic",
        place_on = {"group:soil"},
        sidelen = 8,
        noise_params = {
            offset = -0.0025,
            scale = 0.008,
            spread = {x = 10, y = 10, z = 10},
            seed = 73355,
            octaves = 3,
            persistence = 0.2,
            lacunarity = 2.0,
        },
        biomes = these_biomes,
        y_max = alt_max,
        y_min = sealevel,
        schematic = sch(item.name),
        flags = "place_center_x, place_center_z",
        rotation = "random",
        place_offset_y = 0,
        _layer = item.layer,
    })
end


core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    fill_ratio = 0.0005,
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0,
    _layer = 34,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    fill_ratio = 0.0005,
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0,
    _layer = 35,
})
-- bushes
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    -- fill_ratio = 0.006,
    biomes = these_biomes,
    noise_params = {
      offset = -0.03,
      scale = 0.07,
      spread = {x = 10, y = 10, z = 10},
      seed = 674,
      octaves = 2,
      persistence = 0.1,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    -- fill_ratio = 0.006,
    biomes = these_biomes,
    noise_params = {
      offset = -0.03,
      scale = 0.07,
      spread = {x = 10, y = 10, z = 10},
      seed = 6,
      octaves = 8,
      persistence = 0.7,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_bush_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
    _layer = 39,
})


local size = 30
core.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:cobble",
    wherein		= {"aom_soil:grass", "aom_soil:dirt"},
    clust_scarcity	= 200,
    clust_size	= 12,
    noise_params = {
        offset = 0.3,
        scale = 0.5,
        spread = {x = size, y = size, z = size},
        seed = 438,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.1,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {these_biomes[2]},
})

size = 10
core.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:stone",
    wherein		= {"aom_stone:cobble"},
    clust_scarcity	= 100,
    clust_size	= 8,
    noise_params = {
        offset = 0.3,
        scale = 0.4,
        spread = {x = size, y = size, z = size},
        seed = 5275,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.1,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {these_biomes[2]},
})

local np = {
    offset = sealevel+70,
    scale = 200,
    spread = {x = 4, y = 4, z = 4},
    seed = 764,
    octaves = 2,
    persistence = 0.02,
    lacunarity = 2.0,
}
local npt = {
    offset = -00,
    scale = 190,
    spread = {x = 4, y = 4, z = 4},
    seed = 907,
    octaves = 2,
    persistence = 0.01,
    lacunarity = 2.0,
}

core.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:cobble_moss_1",
    wherein		= {"aom_stone:cobble"},
    clust_scarcity	= 200,
    clust_size	= 6,
    noise_params = np,
    y_max = alt_max,
    y_min = sealevel,
    biomes = these_biomes,
})
np.seed = 42983
core.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:cobble_moss_2",
    wherein		= {"aom_stone:cobble_moss_1"},
    clust_scarcity	= 200,
    clust_size	= 4,
    noise_params = np,
    y_max = alt_max,
    y_min = sealevel,
    biomes = these_biomes,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {
        "group:topsoil", "aom_stone:cobble", "aom_stone:cobble_moss_1", "aom_stone:cobble_moss_2",
        "aom_stone:stone", "aom_stone:stone_brick", "aom_stone:ironstone_brick", "aom_stone:ironstone_cobble",
    },
	sidelen = 4,
	noise_params = {
		offset = -1.3,
		scale = 2.0,
		spread = {x = 8, y = 8, z = 8},
		seed = 7534,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
	biomes = these_biomes,
	y_max = alt_max,
	y_min = alt_min,
	decoration = "aom_spawnnodes:concerning_clover",
    flags = "all_floors",
    _layer = 47,
})

core.register_decoration({
    deco_type = "simple",
	place_on = {
        "aom_stone:stone_brick", "aom_stone:cobble", "aom_stone:ironstone_brick", "aom_stone:ironstone_cobble",
    },
    decoration = {
        "aom_flora:mushroom_glow_green_0", "aom_flora:mushroom_glow_green_1",
    },

    noise_params = {
        offset = 0.08,
        scale = 0.12,
        spread = {x = 8, y = 8, z = 8},
        seed = 8765,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = these_biomes[1],
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})

core.register_decoration({
    deco_type = "simple",
	place_on = {
        "aom_soil:gravel", "aom_stone:cobble",
    },
    decoration = {
        "aom_flora:mushroom_glow_green_0", "aom_flora:mushroom_glow_green_1",
    },

    noise_params = {
        offset = -0.3,
        scale = 0.6,
        spread = {x = 8, y = 8, z = 8},
        seed = 8765,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = these_biomes[2],
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})
