
aom_after_generated = {}

aom_after_generated.cid_after_generated_callbacks = {}
local cidcalls_after = aom_after_generated.cid_after_generated_callbacks

core.register_on_mods_loaded(function()
	for nodename, def in pairs(core.registered_nodes) do
		if def._after_generated then
			local cid = core.get_content_id(nodename)
			cidcalls_after[cid] = def._after_generated
		end
	end
end)

-- local avgtime = 0
local data = {}
local after_generated = function(minp, maxp, seed)
	-- local cl = os.clock()
	local vm, emin, emax = core.get_mapgen_object("voxelmanip")
	local area = VoxelArea:new{MinEdge = emin, MaxEdge = emax}

	local do_after = {}
	vm:get_data(data)
	for z = minp.z, maxp.z do
	for y = minp.y, maxp.y do
		local di = area:index(minp.x, y, z)
		for x = minp.x, maxp.x do
			-- after_generated
			local callback = cidcalls_after[data[di]]
			if callback then
				table.insert(do_after, {
					callback,
					vector.new(x, y, z),
				})
			end
			di = di + 1
		end
	end end
	-- actually run the after_generated calls
	for i, callback in ipairs(do_after) do
		callback[1](callback[2])
	end
	-- avgtime = ((avgtime * 9) + (os.clock()-cl)) * 0.1
	-- core.log(avgtime)
end

-- it's worth the performance tradeoff (marginal) just to be absolutely sure this gets called after the main mapgen is done
-- that's why it's not threaded
core.register_on_generated(after_generated)
