
For development purposes; if not making a mod or developing the game, ignore this file. See `game guide.md` for information for players.

This document lists as many features of the game as possible, and their systems and how to integrate those. Usually, the better bet is to look for how an existing feature uses an API and then go from there, but here will be shortcuts to that.

The code is the only definitive documentation. This, and and `readme.md`s inside each mod or API are not guaranteed to be up to date.

# System

## Wire `aom_wire`
Some nodes can receive inputs from output nodes. A button is an output, since it gives a signal into another node, which is the input. Output = signal, input = receiver. 
```lua
local node_definition = {
    _on_wire_input = function(pos, user, source)
        -- a button or something just activated me
    end,
}
```

You can also register your own outputter nodes like buttons. Look at `aom_wire` for api details.

## Wield Events
`_on_select`, `_on_deselect` and `_on_step` for item, tool and node definitions are not included in Luanti by default. These are handled by `itemextensions` and you don't have to depend on that mod directly in order for these to work. However, for mods it is definitely recommended to depend, since otherwise no one will know why wield events are not happening.


# Node


# Item


# Tool


# Entity


# Map


# Formspec


