local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

age_of_mending = {}
age_of_mending._mod_storage = core.get_mod_storage()
-- information about version such as current, last version, and just upgraded flag
age_of_mending.version = {}


-- the current version of the game as a number, `'a42'` -> `42`
age_of_mending.version.current = 58
--#update--------------------------

rawset(_G, "GAMEVERSION", age_of_mending.version.current)
-- the last loaded version of the game
age_of_mending.version.previous = tonumber(age_of_mending._mod_storage:get_string("version")) or age_of_mending.version.current
-- true if the version is different than the previous loaded version
age_of_mending.version.just_updated = (age_of_mending.version.current ~= age_of_mending.version.previous)

-- update the saved last version; note that it will save downgrades
age_of_mending._mod_storage:set_string("version", age_of_mending.version.current)

-- track first version this world has been opened on
age_of_mending.version.first_for_world = tonumber(age_of_mending._mod_storage:get_string("first_version"))
if not age_of_mending.version.first_for_world then
	age_of_mending.version.first_for_world = age_of_mending.version.previous or age_of_mending.version.current
	age_of_mending._mod_storage:set_string("first_version", age_of_mending.version.first_for_world)
end

core.register_chatcommand("version", {
    params = "",
    description = S("Shows the current version of the game"),
    privs = {},
    func = function(name, param)
		return true, (
			S("Current Version: @1", tostring(age_of_mending.version.current)) .. "\n" ..
			S("Previous Version: @1", tostring(age_of_mending.version.previous)) .. "\n" ..
			S("First Version in World: @1", tostring(age_of_mending.version.first_for_world)) .. "\n" ..
			S("Just Updated: @1", tostring(age_of_mending.version.just_updated))
		)
    end
})
