
aom_combat.telegraph = {}


--[[
{
    source = object,
    radius = 1
}
]]
function aom_combat.telegraph.signal_attack_pos(attacker, pos, radius, dir, spread_angle)
    local victims = core.get_objects_inside_radius(pos, radius or 5)

    for k, victim_object in pairs(victims) do
        local victim = victim_object:get_luaentity()
        if victim and victim._aom_combat_on_telegraph then
            local dir_to_victim = vector.direction(pos, victim_object:get_pos())
            if not dir then dir = vector.copy(dir_to_victim) end

            local angle = vector.angle(dir, dir_to_victim)
            if angle < spread_angle or 3 then
                victim._aom_combat_on_telegraph(attacker, pos)
            end
        end
    end
end

function aom_combat.telegraph.signal_attack(attacker, victim_ent)
    if victim_ent and victim_ent._aom_combat_on_telegraph then
        victim_ent._aom_combat_on_telegraph(attacker, attacker.object:get_pos())
    end
end
