

# Why does this exist?
The original tt mod had license issues; it stated MIT license, but didn't actually provide the license, so respecting the (not included) conditions of the MIT license was impossible. As such, this mod was made with the same (_tt)[.*] tags listened for, but rewritten with better functionality and an explicit zero BSD license.

# How to use
```lua
core.register_node("aom_stone:stone", {
    description = S("Stone"),
    -- can be any field, do not include `\` or color strings
    _some_variable = S("What type of stone? Yes."),
    [...]
})
-- put this in an interface mod or into the /tooltips.lua file obviously!
aom_itemdesc.register_tooltip(function(itemname, def)
    return def._some_variable, "#fa7"
end)
```

Note you may also "jump the queue" with snippet registrations:
```lua
aom_itemdesc.register_tooltip(function(itemname, def)
    return "World", "#fa7"
end)
aom_itemdesc.register_tooltip(function(itemname, def)
    return "Hello", "#fa7"
end, 1) -- puts this in index 1 in the callback array, before other elements

--> My Item
--> Hello
--> World
```


Included by default tooltips are (in order):
1. old description, colored with _tt_color (can be a color or a number which selects an "item tier")
2. _tt_long_desc
3. _tt_how_to_use
4. _tt_help (for compatibility only)
5. _tt_uses (number for tool durability)
6. the internal name e.g. "mod_name:item_name"
