
for i = 1, 14 do
    local light_node = "aom_util:light_node_"..i
    aom_statusfx.register_status("glowing_"..i, {
        ----
        fx_allow_player = true,
        fx_allow_object = true,
        -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
        fx_only_tick_once = false,
        fx_only_apply_once = true,
        fx_timeout_individual = false,
        fx_use_player_functions_for_objects = true,
        ----
        on_apply_player = function(object, count, meta, params)
            meta.next_time = math.floor(meta.time)
            return false -- true to prevent apply
        end,
        on_remove_player = function(object, count, meta, not_timeout)
            return false -- true to prevent remove
        end,
        on_step_player = function(object, count, meta, dtime)
            if meta.next_time and meta.next_time < meta.time - 0.5 then
                meta.next_time = meta.time - 0.5
            end
            if meta.next_time > meta.time then
                meta.next_time = meta.time - 0.5
            else
                return false
            end

            local pos = object:get_pos()
            pos.y = pos.y + 1.1
            local node = core.get_node(pos)
            if node.name == light_node then
                core.get_node_timer(pos):start(1)
                return
            end

            if node.name == "air" then
                node.name = light_node
                core.set_node(pos, node)
                core.get_node_timer(pos):start(1)
            end

            return false -- true to remove
        end,
        ----
        hud = aom_statusfx.hud.make_effect("aom_status_glowing.png")
        ----
    })
end
