local function reg_regen(interval, hud_image)
    aom_statusfx.register_status("regeneration_"..tostring(interval), {
        ----
        fx_allow_player = true,
        fx_allow_object = true,
        -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
        fx_only_tick_once = false,
        fx_only_apply_once = true,
        fx_timeout_individual = false,
        fx_use_player_functions_for_objects = true,
        ----
        on_apply_player = function(object, count, meta, params)
            meta.until_next_effect = interval
            return false -- true to prevent apply
        end,
        on_remove_player = function(object, count, meta, not_timeout)
            return false -- true to prevent remove
        end,
        on_step_player = function(object, count, meta, dtime)
            meta.until_next_effect = meta.until_next_effect - dtime
            if meta.until_next_effect <= 0 then
                meta.until_next_effect = meta.until_next_effect + interval
                if core.is_player(object) -- don't heal if dead
                and (object:get_meta():get_string("dead") == "true") then
                    return false
                end
                object:set_hp(object:get_hp() + 1, "regeneration")
            end
            return false -- true to remove
        end,
        ----
        hud = (hud_image and aom_statusfx.hud.make_effect(hud_image)) or nil
        ----
    })
end


reg_regen(1, "aom_status_regeneration_1.png")
reg_regen(3, "aom_status_regeneration_3.png")
reg_regen(8, "aom_status_regeneration.png^[opacity:100")
reg_regen(20)

-- core.register_on_joinplayer(function(player, last_login)
--     core.after(3, function()
--         if not aom_statusfx.player_has_status(player, "regeneration_20") then
--             aom_statusfx.apply_status(player, "regeneration_20", 999, {})
--         end
--     end)
-- end)
