local S = core.get_translator(core.get_current_modname())

local delme = function(p)
    local node = core.get_node(p)
    if core.get_item_group(node.name, "aom_util_transient_light") > 0 then
        core.set_node(p, {name = "air"})
    end
end

for i = 1, 14 do
    core.register_node("aom_util:light_node_"..i, {
        description = S("Transient Light Node"),
        groups = { aom_util_transient_light = i, not_in_creative_inventory = 1, },
        paramtype = 'light',
        drawtype = "airlike",
        floodable = true,
        pointable = false,
        walkable = false,
        buildable_to = true,
        sunlight_propagates = true,
        drop = "",
        light_source = i,
        on_timer = delme,
        on_construct = function(pos)
            core.get_node_timer(pos):start(5)
        end
    })
end

-- core.register_abm({
--     nodenames = {"group:aom_util_transient_light"},
--     interval = 5.0,
--     chance = 10,
--     action = function(pos, node, active_object_count, active_object_count_wider)
--         if not core.get_node_timer(pos).is_started then
--             core.get_node_timer(pos):start(1)
--         end
--     end
-- })
