local S = core.get_translator(core.get_current_modname())
local save_path = core.get_worldpath()

local serverinfo = {
    dtimeavg = 0.1
}

core.register_chatcommand("serverinfo", {
    params = "",
    description = S("Tells you the avg step time"),
    privs = {},
    func = function(name, param)
        aom_util.get_abm_calls()
        -- TL: @1 is time in seconds ("0.021452")
        return true, "  " .. S("Server step avg: @1s", tostring(serverinfo.dtimeavg))
    end
})

core.register_globalstep(function (dtime)
    serverinfo.dtimeavg = (serverinfo.dtimeavg * 99 + dtime) / 100
end)
