local S = core.get_translator(core.get_current_modname())

aom_items.bucket = {}

function aom_items.bucket.put_liquid(itemstack, user, pointed_thing, liquid_node_name)
    if not itemstack then return nil end
    itemstack = ItemStack(itemstack)

    -- check to make sure it can be placed here
    local backstack, placepos = core.item_place(ItemStack(liquid_node_name), user, pointed_thing)
    if not placepos then return itemstack end

    -- deal with items
    local name = user:get_player_name()
    local sdef = core.registered_items[itemstack:get_name()]

    if not core.is_creative_enabled(name) then
        local leftover = ItemStack(sdef._empty)
        itemstack:take_item(1)
        if itemstack:get_count() == 0 then
            itemstack = leftover
            leftover = nil
        end
        if leftover then
            leftover = leftover
            leftover = user:get_inventory():add_item("main", leftover)
        end
        if leftover then
            core.add_item(user:get_pos(), leftover)
        end
    end

    return itemstack
end

local function get_eyepos(player)
    local eyepos = vector.add(player:get_pos(), vector.multiply(player:get_eye_offset(), 0.1))
    eyepos.y = eyepos.y + player:get_properties().eye_height
    return eyepos
end

local function get_pointed_liquid(player, eyepos)
    if not eyepos then eyepos = get_eyepos(player) end
    local range = aom_util.get_tool_range(player:get_wielded_item())
    local ray = core.raycast(eyepos, vector.add(eyepos, vector.multiply(player:get_look_dir(), range)), false, true)
    for pointed_thing in ray do
        if pointed_thing.type == "node" then
            local nd = core.registered_nodes[core.get_node(pointed_thing.under).name]
            if nd and nd.drawtype == "liquid" then
                return pointed_thing
            end
        end
    end
    return nil
end

function aom_items.bucket.get_liquid(itemstack, user, pointed_thing, no_dig)
    if (not core.is_player(user)) then return end
    itemstack = ItemStack(itemstack)

    pointed_thing = get_pointed_liquid(user)

    if not pointed_thing then return nil end
    local node = core.get_node(pointed_thing.under)
    local sdef = core.registered_items[itemstack:get_name()]
    if not sdef._filled then return itemstack end
    local filled = sdef._filled[node.name]
    if not filled then return itemstack end

    if not no_dig then
        core.set_node(pointed_thing.under, {name="air"})
    end

    local name = user:get_player_name()
    if not core.is_creative_enabled(name) then
        local leftover = ItemStack(filled)
        itemstack:take_item(1)
        if itemstack:get_count() == 0 then
            itemstack = leftover
            leftover = nil
        end
        if leftover then
            leftover = leftover
            leftover = user:get_inventory():add_item("main", leftover)
        end
        if leftover then
            core.add_item(user:get_pos(), leftover)
        end
    end

    return itemstack
end

core.register_craftitem("aom_items:wooden_bucket", {
    description = S("Wooden Bucket"),
    inventory_image = "aom_wooden_bucket.png",
    groups = { item_wooden_bucket = 1, craftitem = 1, tool = 1, wooden_bucket = 1, },
    -- liquids_pointable = true,
    _filled = {
        ["aom_liquids:water_source"] = "aom_items:wooden_bucket_water",
        ["aom_liquids:river_water_source"] = "aom_items:wooden_bucket_river_water",
    },
    stack_max = 8,
    on_secondary_use = function(itemstack, user, pointed_thing)
        return aom_items.bucket.get_liquid(itemstack, user, pointed_thing)
    end,
    on_place = function(itemstack, user, pointed_thing)
        return aom_items.bucket.get_liquid(itemstack, user, pointed_thing)
    end,
})
core.register_craftitem("aom_items:wooden_bucket_water", {
    description = S("Wooden Bucket of Water"),
    inventory_image = "aom_wooden_bucket_water.png",
    groups = { item_wooden_bucket_water = 1, craftitem = 1, tool = 1, wooden_bucket = 1, water_bucket = 1},
    stack_max = 1,
    _empty = "aom_items:wooden_bucket",
    on_place = function(itemstack, user, pointed_thing)
        return aom_items.bucket.put_liquid(itemstack, user, pointed_thing, "aom_liquids:water_source")
    end,
})
core.register_craftitem("aom_items:wooden_bucket_river_water", {
    description = S("Wooden Bucket of River Water"),
    inventory_image = "aom_wooden_bucket_water.png",
    groups = { item_wooden_bucket_water = 1, craftitem = 1, tool = 1, wooden_bucket = 1, water_bucket = 1},
    stack_max = 1,
    _empty = "aom_items:wooden_bucket",
    on_place = function(itemstack, user, pointed_thing)
        return aom_items.bucket.put_liquid(itemstack, user, pointed_thing, "aom_liquids:river_water_source")
    end,
})

-- core.register_craft({
--     output = "aom_items:wooden_bucket",
--     recipe = {
--         {"",             "group:stick",  ""},
--         {"group:planks", "",             "group:planks"},
--         {"group:planks", "group:planks", "group:planks"},
--     },
-- })
aom_tcraft.register_group_craft({
    output = "aom_items:wooden_bucket",
    items = {},
    group = "planks",
    group_count = 5
})


core.register_craftitem("aom_items:wooden_cup", {
    description = S("Wooden Cup"),
    inventory_image = "aom_wooden_cup.png",
    groups = { item_wooden_cup = 1, craftitem = 1, wooden_cup = 1, },
    -- liquids_pointable = true,
    _filled = {
        ["aom_liquids:water_source"] = "aom_items:wooden_cup_water",
        ["aom_liquids:river_water_source"] = "aom_items:wooden_cup_water",
    },
    stack_max = 64,
    on_secondary_use = function(itemstack, user, pointed_thing)
        return aom_items.bucket.get_liquid(itemstack, user, pointed_thing)
    end,
    on_place = function(itemstack, user, pointed_thing)
        return aom_items.bucket.get_liquid(itemstack, user, pointed_thing, true)
    end,
})

core.register_craftitem("aom_items:wooden_cup_water", {
    description = S("Cup of Water"),
    inventory_image = "aom_wooden_cup_water.png",
    groups = { item_wooden_cup = 1, craftitem = 1, wooden_cup = 1, food = 1, provides_water = 1 },
    stack_max = 64,
})
aom_util.register_wield_use_delay("aom_items:wooden_cup_water", {
    windup = 2,
    sound = {
        name = "aom_food_gulp",
        gain = 0.8,
        max_hear_distance = 20,
        pitch = 1
    },
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_8"] = 8*2+1,
    }, "aom_items:wooden_cup", aom_food.sound.gulp())
})
-- core.register_craft({
--     output = "aom_items:wooden_cup 8",
--     recipe = {
--         {"group:planks", "",             "group:planks"},
--         {"group:planks", "",             "group:planks"},
--         {"group:planks", "group:planks", "group:planks"},
--     },
-- })
aom_tcraft.register_group_craft({
    output = "aom_items:wooden_cup",
    items = {},
    group = "planks",
    group_count = 1
})
