aom_elemental.magma = {}
function aom_elemental.magma.do_sound(self, name, gain)
    core.sound_play(("aom_elementals_"..name), {
        gain = gain or 1,
        pos = self.object:get_pos(),
        object = self.object,
    })
end

local animspeedmult = 0.7


if true then
    local stone = core.registered_entities["aom_elementals:stone"]
    local mag = table.copy(stone)

    mag.initial_properties = table.copy(mag.initial_properties)
    mag.initial_properties.textures = {"aom_elemental_magma.png"}
    mag.initial_properties.glow = 3
    mag.name = "aom_elementals:magma"
    mag._drop = {
        minmax = {
            {min = -2, max = 3,  item = "aom_underworld:mythril_strand"},
            {min = -1, max = 2,  item = "aom_underworld:cortite"},
            {min = 30, max = 80,  item = "aom_underworld:lava_rock"},
            {min = 4, max = 16,  item = "aom_items:ignis"},
        },
        items = {
            {rarity = 16, items = {"aom_elementals:elemental_core_magma"}},
        },
    }

    mag._aom_speed = mag._aom_speed / animspeedmult
    mag._aom_acceleration = 10
    mag._knockback = 0.1
    mag._damagemult = 2
    mag._knockbackmult = 2

    for i, anim in pairs(mag._animations) do
        mag._animations[i] = table.copy(anim)
        mag._animations[i].speed = (mag._animations[i].speed or 24) / animspeedmult
    end

    core.register_entity("aom_elementals:magma", mag)
end


core.register_craftitem("aom_elementals:magma_spawn",
{
    description = "magma Elemental spawn egg",
    inventory_image = "aom_elemental_stone.png",
    on_place = function(itemstack, placer, pointed_thing)
        local ent = core.add_entity(vector.offset(core.get_pointed_thing_position(pointed_thing), 0, 1, 0), "aom_elementals:magma")
    end,
})
