

if core.get_modpath("aom_mob_spawn") then
    local spawnable_nodes = {
        ["aom_stone:stone"] = true,
        ["aom_stone:sandstone"] = true,
        ["aom_stone:granite"] = true,
        ["aom_stone:limestone"] = true,
        ["aom_stone:cobble_moss_1"] = true,
        ["aom_stone:cobble_moss_2"] = true,
    }
    aom_mob_spawn.register_mob({
        name = "aom_kelar:kelar",
        groups = {"hostile", "aom_kelar"},
        biomes = {},
        on_spawn = function(self, pos)
            for i = 0, (math.random(0,4)) do
                local spos = vector.offset(
                    pos,
                    (math.random()*2-1) * 2,
                    0.5,
                    (math.random()*2-1) * 2
                )
                local obj = core.add_entity(spos, "aom_kelar:kelar")
                obj:set_yaw(math.random() * math.pi * 2)
            end
        end,
        can_spawn = function(pos, spawn_info)
            if not spawnable_nodes[spawn_info.node_below.name] then return false end
            if not aom_dimensions.is_in("overworld", pos) then return false end
            if not aom_mob_spawn.has_head_room(pos, 2) then return false end
            -- not near artificial light, nor sunlight
            if aom_mob_spawn.has_light(pos, 0, 2, nil) then
                if aom_entity_api.has_mobs_in_radius(pos, 60, {"aom_kelar:kelar"}, 0, 2) then
                    return true
                end
            end
            return false
        end,
        can_despawn = function(self)
            if self._age and self._age < 120 then return false end
            return true
        end,
    })
    local biomes = {
        underworld = true,
        underworld_bridges = true,
        underworld_coral = true,
    }
    aom_mob_spawn.register_mob({
        name = "aom_kelar:kelar_underworld",
        groups = {"hostile", "aom_kelar"},
        biomes = {},
        on_spawn = function(self, pos)
        end,
        can_spawn = function(pos, spawn_info)
            if math.random() < 0.5 then return false end
            if not aom_dimensions.is_in("underworld", pos) then return false end
            if not biomes[spawn_info.biome_name or "nil"] then return false end
            local below_node = core.get_node(vector.offset(pos, 0, -1, 0))
            if (below_node.name ~= "aom_underworld:lava_rock")
            and (below_node.name ~= "aom_underworld:lava_rock_coral") then return false end
            if not aom_mob_spawn.has_head_room(pos, 2) then return false end
            if aom_mob_spawn.has_light(pos, 0, 7) then
                if aom_entity_api.has_mobs_in_radius(pos, 40, {"aom_kelar:kelar_underworld"}, 0, 1) then
                    return true
                end
            end
            return false
        end,
        can_despawn = function(self)
            if self._age and self._age < 20 then return false end
            return true
        end,
    })
    aom_mob_spawn.cap.aom_kelar.max = 20
end
