---@diagnostic disable: undefined-doc-name


local function debug_particle(pos, color, time)
    do return end -- for debug purposes
    core.add_particle({
        size = 8,
        pos = pos + vector.new(0, math.random(), 0),
        texture = "white.png^[colorize:"..color..":255",
        velocity = vector.new(0, math.random(), 0),
        expirationtime = time,
        glow = 14,
    })
end

function aom_mob_spawn.is_cap_exceded(mob_name, cap_multiplier)
    for _, groupname in pairs(aom_mob_spawn.mob[mob_name].groups) do
        if aom_mob_spawn.cap[groupname].cur > (aom_mob_spawn.cap[groupname].max * (cap_multiplier or 1)) then
            return true
        end
    end
    return false
end

-- pick a mob based on the location
function aom_mob_spawn.get_spawn_mob(pos, choosefrom)
    if not aom_mob_spawn.has_player_in_range(pos, aom_mob_spawn.spawn_dist.min, aom_mob_spawn.spawn_dist.max) then return false end
    if aom_mob_spawn.has_player_in_range(pos, 0, aom_mob_spawn.spawn_dist.min) then return false end

    local test_in = choosefrom or aom_mob_spawn.mob_index
    local biome_data = core.get_biome_data(pos)
    local spawn_info = {
        biome_name = core.get_biome_name(biome_data.biome),
        biome_data = biome_data,
        node_below = core.get_node(vector.offset(pos, 0, -1, 0))
    }

    local i = math.random(1, #test_in)
    for try=1, #test_in do
        local mob_name = test_in[i]
        local mob_reg = aom_mob_spawn.mob[mob_name]
        if not mob_reg then goto continue end
        if (mob_reg.biomes and #mob_reg.biomes > 0
        and mob_reg.biomes[spawn_info.biome_name] == nil) then
            -- core.chat_send_all("could not spawn " .. tostring(mob_name) .. ", biome " .. tostring(spawn_info.biome_name) .. " not allowed.")
            return end

        if aom_mob_spawn.is_cap_exceded(mob_name, 0.5) then
            -- core.log(core.colorize("#f95", dump(mob_name) .. " cap exceeded"))
            goto continue end

        if mob_reg.can_spawn and not mob_reg.can_spawn(pos, spawn_info) then
            -- core.log(core.colorize("#f0f", dump(mob_name) .. " mob doesn't want to spawn"))
            debug_particle(pos, "#f02", 15)
            goto continue
        end

        if true then
            -- core.log(core.colorize("#0f5", dump(mob_name)))
            debug_particle(pos, "#0f2", 15)
            return mob_name
        end

        ::continue::
        i = i % #test_in + 1
    end
    return nil
end

function aom_mob_spawn.add_to_cap(mob_name)
    if not aom_mob_spawn.mob[mob_name] then
        -- core.log(mob_name)
        return false
    end
    for _, groupname in pairs(aom_mob_spawn.mob[mob_name].groups) do
        aom_mob_spawn.cap[groupname].cur = aom_mob_spawn.cap[groupname].cur + 1
    end
    aom_mob_spawn.cap["all"].cur = aom_mob_spawn.cap["all"].cur + 1
end
function aom_mob_spawn.take_from_cap(mob_name)
    if not aom_mob_spawn.mob[mob_name] then
        return false
    end
    for _, groupname in pairs(aom_mob_spawn.mob[mob_name].groups) do
        aom_mob_spawn.cap[groupname].cur = aom_mob_spawn.cap[groupname].cur - 1
    end
    aom_mob_spawn.cap["all"].cur = aom_mob_spawn.cap["all"].cur - 1
end
function aom_mob_spawn.reset_cap()
    for groupname, group in pairs(aom_mob_spawn.cap) do
        if not group.cur or group.cur == 0 then
        else
            group.cur = 0
        end
    end
end
function aom_mob_spawn.recalculate_cap()
    aom_mob_spawn.reset_cap()
    for _, self in pairs(core.luaentities) do
        if self.name and aom_mob_spawn.mob[self.name] then
            aom_mob_spawn.add_to_cap(self.name)
        end
    end
end


LISTEN("can_mob_spawn_standard", function(pos, mob_name)
    return aom_spawn_inhibitors.is_uninhibited(pos)
end)

-- try to spawn a random mob at a location
-- returns mob lua ent or nil
function aom_mob_spawn.spawn_mob_at(pos)
    local mob_name = aom_mob_spawn.get_spawn_mob(pos)
    -- core.log("spawn try for " .. dump(mob_name))
    if (not mob_name) or not core.registered_entities[mob_name] then
        debug_particle(pos, "#ff00ff50", 15)
        return
    else
        debug_particle(pos, "#ff0", 15)
        -- core.log(core.colorize("#ff0", dump(mob_name) .. " :: SUCCESS"))
    end

    if CONDITIONAL("can_mob_spawn_standard", pos, mob_name) == false then return end

    local mob_obj = core.add_entity(pos, mob_name)
    -- me.add_to_cap(mob_name)
    local self = mob_obj:get_luaentity()

    -- do the mob's spawn func
    if aom_mob_spawn.mob[mob_name].on_spawn then
        aom_mob_spawn.mob[mob_name].on_spawn(self, pos)
    end

    return self
end

---Finds the position y+1 of a `full_solid` node that is not `walkable`, or nil on failure
---@param pos vector
---@param max_search number|nil
---@return vector|nil
function aom_mob_spawn.find_ground_pos(pos, max_search)
    local sdef = core.registered_nodes[core.get_node(pos).name]
    if sdef and sdef.walkable then
        for i=1, max_search or 10 do
            local p = vector.offset(pos, 0, i, 0)
            local node = core.get_node(p)
            local def = core.registered_nodes[node.name]
            if def and not def.walkable then
                if core.get_item_group(node.name, "full_solid") == 0 then
                    return vector.offset(pos, 0, i, 0)
                end
            end
        end
    else
        for i=0, max_search or 10 do
            local p = vector.offset(pos, 0, -i, 0)
            local node = core.get_node(p)
            local def = core.registered_nodes[node.name]
            if def and def.walkable then
                if core.get_item_group(node.name, "full_solid") > 0 then
                    return vector.offset(p, 0, 1, 0)
                end
            end
        end
    end
    return nil
end

function aom_mob_spawn.can_despawn(self)
    local name = self.name
    local pos = self.object:get_pos()
    -- force to despawn after a certain dist
    local default_despawn
    if pos and not aom_mob_spawn.has_player_in_range(pos, 0, aom_mob_spawn.despawn_dist_force) then
        default_despawn = true
    -- don't despawn if close to player
    elseif pos and (aom_mob_spawn.has_player_in_range(pos, 0, aom_mob_spawn.despawn_dist) or (self._no_despawn == true)) then
        default_despawn = false
    end
    -- figure out based on the custom func if it can despawn
    local can_despawn = ((aom_mob_spawn.mob[name].can_despawn ~= nil) and aom_mob_spawn.mob[name].can_despawn(self)) or false
    -- do it slowly, by using a random chance
    if (default_despawn == true) or (can_despawn and default_despawn == nil) then
        return true
    end
    -- if all else fails, don't despawn
    return false
end

function aom_mob_spawn.despawn_all()
    for _, self in pairs(core.luaentities) do
        if self.name then
            if not aom_mob_spawn.mob[self.name] then break end

            if aom_mob_spawn.can_despawn(self) then
                aom_mob_spawn.take_from_cap(self.name)
                self.object:remove()
            end
        end
    end
end

core.register_abm({
    label = "aom_mob_spawn:main_spawner",
    nodenames = {"air"},
    neighbors = {"group:full_solid"},
    interval = 10,
    chance = 8000,
    action = function(pos, node, active_object_count, active_object_count_wider)
        local old_spawning = aom_settings.get_setting(nil, "mob_spawn_old", true)
        if not old_spawning then return end
        core.after(math.random() * 10, function()
            aom_util.did_abm("mob spawn")
            if not aom_mob_spawn.enabled then return false end
            local ground = aom_mob_spawn.find_ground_pos(pos)
            if not ground then return false end
            local mob = aom_mob_spawn.spawn_mob_at(ground)
        end)
    end
})


-- despawn mobs and recalculate mob cap manually for now until it can be made better
local despawn_timer = 1
local _t = 0
local on_globalstep = function(dtime)
    if not aom_mob_spawn.enabled then return false end
    despawn_timer = despawn_timer - dtime
    if despawn_timer < 0 then
        despawn_timer = despawn_timer + 5
        aom_mob_spawn.recalculate_cap()
        aom_mob_spawn.despawn_all()
        -- don't spawn if world is new and slowly ramp up max hostile mobs
        local max_cap = aom_mob_spawn.get_setting(nil, "mob_hostile_max", 100)
        local mob_grace = aom_mob_spawn.get_setting(nil, "mob_hostile_grace_time", 20)
        local time = (core.get_gametime() or 0) / 60
        local time_factor = math.max(0, time - mob_grace) * 0.01 + math.log(math.max(1, time + 1 - mob_grace), 10) * 20
        aom_mob_spawn.cap.hostile.max = math.min(max_cap, math.floor(time_factor))
    end
end
core.register_globalstep(on_globalstep)

