local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

local fern_box = {
    type = "fixed",
    fixed = {
        -6/16, -8/16, -6/16,
        6/16, 2/16, 6/16,
    }
}

local function register_fern(node_name, tiles)
    local name = string.lower(node_name)
    core.register_node('aom_flora:' .. name, {
        description = S("Fern"),
        drawtype = "plantlike",
        walkable = false,
        floodable = true,
        waving = 1,
        paramtype = "light",
        inventory_image = "aom_" .. name .. ".png",
        wield_image = "aom_" .. name .. ".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = fern_box,
        groups = { nature = 1, attached_node = 1, item_fern = 1, item_burns = 1, dig_immediate = 3, flora = 1, decoration = 1, },
        drop = aom_flora.grass_drops,
        tiles = tiles,
        buildable_to = true,
        sounds = aom_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
    })
end

register_fern("fern_0", {"aom_fern_0.png"})
register_fern("fern_1", {"aom_fern_1.png"})
-- register_fern("fern_2", {"aom_fern_2.png"})
-- register_fern("fern_3", {"aom_fern_3.png"})
