local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

local mushroom_box = {
    type = "fixed",
    fixed = {
        -2/16, -8/16, -2/16,
        2/16, 4/16, 2/16,
    }
}


function aom_flora.register_mushroom(type, name, params)
    if not params then params = {} end
    local node_name = params.node_name or ("aom_flora:mushroom_" .. type)
    local tile = params.tile or ("aom_mushroom_"..type..".png")
    core.register_node(node_name, {
        -- TL: @1 is type of mushroom ("Brown")
        description = S("@1 Mushroom", name),
        drawtype = "plantlike",
        walkable = false,
        floodable = true,
        -- waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        param2 = 8,
        inventory_image = tile,
        wield_image = tile,
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = mushroom_box,
        light_source = params.light_source or nil,
        drop = params.drop or nil,
        groups = {
            nature = 1, attached_node = 3, snappy = 3, dig_immediate = 3, flora = 1,
            mushroom = 1, player_place_only = 1, item_burns = 1, decoration = 1,
            [params.mushroom_group or ("mushroom_"..type)] = 1,
            not_in_creative_inventory = (params.not_in_creative_inventory and 1) or nil,
        },
        tiles = params.tiles or {tile},
        sounds = aom_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, params.placeable_on or {"soil"})
        end,
        on_construct = params.on_construct or function(pos)
            local node = core.get_node(pos)
            node.param2 = 8 -- this makes it randomly offset horizontally
            core.swap_node(pos, node)
        end,
        _mushroom_group = params.mushroom_group or ("mushroom_"..type)
    })
end

-- TL: type of mushroom
aom_flora.register_mushroom("brown", S("Brown"))
-- TL: type of mushroom
aom_flora.register_mushroom("red", S("Red"))
-- TL: type of mushroom
aom_flora.register_mushroom("white", S("White"))

-- yellow glowing mushrooms
-- TL: type of mushroom
aom_flora.register_mushroom("glow_yellow_0", S("Yellow Glowing"), {
    light_source = 7,
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8
        node.name = "aom_flora:mushroom_glow_yellow_" .. math.random(0,1)
        core.swap_node(pos, node)
    end,
    mushroom_group = "mushroom_glowing_yellow",
})
aom_flora.register_mushroom("glow_yellow_1", S("Yellow Glowing"), {
    light_source = 5, drop = "aom_flora:mushroom_glow_yellow_0",
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8
        node.name = "aom_flora:mushroom_glow_yellow_" .. math.random(0,1)
        core.swap_node(pos, node)
    end,
    not_in_creative_inventory = 1,
    mushroom_group = "mushroom_glowing_yellow",
})

-- blue glowing mushrooms
-- TL: type of mushroom
aom_flora.register_mushroom("glow_blue_0", S("Blue Glowing"), {
    light_source = 7,
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8
        node.name = "aom_flora:mushroom_glow_blue_" .. math.random(0,1)
        core.swap_node(pos, node)
    end,
    mushroom_group = "mushroom_glowing_blue",
})
aom_flora.register_mushroom("glow_blue_1", S("Blue Glowing"), {
    light_source = 7, drop = "aom_flora:mushroom_glow_blue_0",
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8
        node.name = "aom_flora:mushroom_glow_blue_" .. math.random(0,1)
        core.swap_node(pos, node)
    end,
    not_in_creative_inventory = 1,
    mushroom_group = "mushroom_glowing_blue",
})

-- green glowing mushrooms
-- TL: type of mushroom
aom_flora.register_mushroom("glow_green_0", S("Green Glowing"), {
    light_source = 7,
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8
        node.name = "aom_flora:mushroom_glow_green_" .. math.random(0,1)
        core.swap_node(pos, node)
    end,
    mushroom_group = "mushroom_glowing_green",
})
aom_flora.register_mushroom("glow_green_1", S("Green Glowing"), {
    light_source = 7, drop = "aom_flora:mushroom_glow_green_0",
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8
        node.name = "aom_flora:mushroom_glow_green_" .. math.random(0,1)
        core.swap_node(pos, node)
    end,
    not_in_creative_inventory = 1,
    mushroom_group = "mushroom_glowing_green",
})

aom_util.register_wield_use_delay("aom_flora:mushroom_red", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["poison_3"] = 9+1,
        ["woozy"] = 20,
    })
})
aom_util.register_wield_use_delay("aom_flora:mushroom_white", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["poison_3"] = 9+1,
        ["featherfalling"] = 30,
    })
})
aom_util.register_wield_use_delay("aom_flora:mushroom_brown", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_8"] = 8+1,
    })
})
aom_util.register_wield_use_delay("aom_flora:mushroom_glow_yellow_0", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_1"] = 7,
        ["poison_3"] = 9+1,
    })
})
aom_util.register_wield_use_delay("aom_flora:mushroom_glow_blue_0", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 1.5,
    on_use = aom_food.eat({
        ["poison_3"] = 9+1,
        ["featherfalling"] = 30,
    })
})
aom_util.register_wield_use_delay("aom_flora:mushroom_glow_green_0", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_1"] = 7,
        ["woozy"] = 12,
    })
})

-- grow mushrooms
local mushroom_searchsize = vector.new(3,2,3)
local mushroom_growsize = vector.new(2,2,2)
core.register_abm({
    nodenames = {"group:mushroom"},
    interval = 30.0,
    chance = 50,
    action = function(pos, node, active_object_count, active_object_count_wider)
        aom_util.did_abm("mushroom")
        -- don't spread if mapgen placed (on_construct not triggered)
        if node.param2 == 0 then return end

        local light = core.get_node_light(pos, 0.5)
        if light > 8 then return false end

        local sp1 = vector.subtract(pos, mushroom_searchsize)
        local sp2 = vector.add(pos, mushroom_searchsize)

        local ndef = core.registered_nodes[node.name]
        local name = (ndef and (ndef._mushroom_group and ("group:"..ndef._mushroom_group))) or node.name
        local mushrooms = core.find_nodes_in_area(sp1, sp2, name)
        if #mushrooms > 6 then return end

        sp1 = vector.subtract(pos, mushroom_growsize)
        sp2 = vector.add(pos, mushroom_growsize)
        local nodes = core.find_nodes_in_area_under_air(sp1, sp2, "group:soil")
        local index = math.random(1, #nodes)
        if #nodes < 1 then return end
        for i = 1, 8 do
            local place_pos = vector.offset(nodes[index], 0, 1, 0)
            if core.get_node(place_pos).name == "air" then
                core.set_node(place_pos, {name=node.name})
            end
        end
    end,
})

