local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)


local potato_box = {
    type = "fixed",
    fixed = {
        -6/16, -8/16, -6/16,
        6/16, -6/16, 6/16,
    }
}

local potato_variants = {}

local function random_grow_time()
    return (math.random() * 100 + 300)
end

local crop_fail_chance = 0.1

local function grow_potato(pos, node, active_object_count, active_object_count_wider)
    aom_util.did_abm("crop")
    local light = core.get_node_light(pos, 0.5)
    if light > 8 then
        local def = core.registered_nodes[node.name]
        local next_stage = (def and def._growth_stage + 1) or 1
        -- random chance to leave as immature plant
        if next_stage >= 2 and (math.random() < crop_fail_chance) then return end
        node.name = "aom_flora:potato_" .. next_stage
        if not core.registered_nodes[node.name] then return false end

        core.set_node(pos, node)
        return true
    end
end

local drops = {
    full = {
        max_items = 4,
        items = {
            {
                items = {'aom_flora:potato_seeds 1'},
            },
            {
                items = {'aom_flora:potato_seeds 1'},
                rarity = 2
            },
            {
                items = {'aom_flora:potato_seeds 2'},
                rarity = 3
            },
        },
    },
    partial = {
        max_items = 1,
        items = {
            {
                items = {'aom_flora:potato_seeds'},
            },
        },
    },
}

core.register_node("aom_flora:potato_seeds", {
    description = S("Potato"),
    _tt_long_desc = S("Can be cooked or placed in soil."),
    inventory_image = "aom_potato_seeds.png",
    wield_image = "aom_potato_seeds.png",
    drawtype = "airlike",
    walkable = false,
    floodable = true,
    paramtype = "light",
    selection_box = {
        type = "fixed",
        fixed = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},},
    is_ground_content = true,
    sunlight_propagates = true,
        groups = { item_potato_seeds = 1, seed = 1, craftitem = 1, player_place_only = 1, item_burns = 1, decoration = 1, },
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        core.set_node(pos, {name=potato_variants[1], param2 = 8})
        local timer = core.get_node_timer(pos)
        timer:start(random_grow_time())
    end,
    on_place = function(itemstack, placer, pointed_thing)
        local ret = aom_util.try_rightclick(itemstack, placer, pointed_thing)
        if ret then return ret end
        return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
    end,
})

local function register_potato(node_name)
    for i=0, 4 do
        local name = string.lower(node_name)
        local drop = (i == 4 and drops["full"]) or drops["partial"]
        local tiles = {"aom_potato_" .. i .. ".png"}
        local growing = ((i ~= 4) and i + 1) or 0
        potato_variants[#potato_variants+1] = 'aom_flora:potato_' .. i
        core.register_node('aom_flora:potato_' .. i, {
        description = S("Potato Plant"),
        drawtype = "plantlike",
        walkable = false,
        waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        inventory_image = "aom_potato_" .. i .. ".png",
        wield_image = "aom_potato_" .. i .. ".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = potato_box,
        groups = { nature = 1, attached_node = 1, item_potato_plant = 1, not_in_creative_inventory = 1,
        dig_immediate = 3, flora = 1, growth_stage = i, potato_growing = growing },
        _growth_stage = i,
        drop = drop,
        tiles = tiles,
        buildable_to = false,
        sounds = aom_sounds.default_plant(),
        after_place_node = function(pos, placer, itemstack, pointed_thing)
            local variant = potato_variants[math.random(1, #potato_variants)]
            core.swap_node(pos, {name=variant, param2 = 8})
        end,
        on_timer = function(pos, elapsed)
            if grow_potato(pos, core.get_node(pos)) then
                local timer = core.get_node_timer(pos)
                timer:start(random_grow_time())
            end
        end,
        _on_node_update = function(pos, cause, user, data)
            local timer = core.get_node_timer(pos)
            if timer:is_started() then
                return false
            else
                timer:start(random_grow_time())
            end
        end,
        })
    end
end

-- 4 growth stages
register_potato("potato_")

-- -- grow potato
-- core.register_abm({
--     nodenames = {'group:potato_growing'},
--     interval = 10.0, --10
--     chance = 50, --50
--     action = grow_potato,
-- })
-- -- grow potato faster near water?
-- core.register_abm({
--     nodenames = {'group:potato_growing'},
--     neighbors = {"group:water"},
--     interval = 10.0, --10
--     chance = 40, --50
--     action = grow_potato,
-- })


