local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

core.register_node("aom_rope:chain", {
    description = S("Chain"),
    _tt_long_desc = S("Can be climbed on."),
    groups = { item_chain = 1, solid = 1, snappy = 3, tool = 1, player_place_only = 1, oddly_breakable_by_hand = 1, chain = 1, rope = 1, },
    tiles = { "aom_rope_chain.png" },
    drawtype = "plantlike",
    collision_box = {0, 0, 0, 0, 0, 0},
    walkable = false,
    floodable = true,
    sunlight_propagates = true,
    paramtype = "light",
    use_texture_alpha = "clip",
    selection_box = {
        type = "fixed",
        fixed = {
            -3/16, -8/16, -3/16,
             3/16,  8/16,  3/16,
        }
    },
    sounds = aom_sounds.default_metal(),
    climbable = true,
    _on_node_update = function(pos, cause, user, count, payload)
        core.after(0.01, aom_rope.rope_update, pos, cause, user, count, payload)
    end,
    on_construct = function(pos)
        aom_rope.rope_update(pos, "place", nil, {})
    end,
    on_place = aom_rope.rope_place,
    -- on_secondary_use = aom_rope.on_use,
})

core.register_craft({
    output = "aom_rope:chain 16",
    recipe = {
        {"aom_items:iron_bar"},
        {"aom_items:iron_bar"},
        {"aom_items:iron_bar"},
    }
})
