local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)


core.register_node("aom_stone:ironstone", {
    description = S("Ironstone"),
    groups = {
        full_solid = 1, nature = 1, ironstone = 1, material_ironstone = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1 },
    tiles = { "aom_stone_ironstone.png" },
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:ironstone", {}, {remove_groups={"natural_stone"}})
aom_stone.register_two_way_craft("aom_stone:ironstone_cobble", "aom_stone:ironstone")

core.register_node("aom_stone:ironstone_cobble", {
    description = S("Cobbled Ironstone"),
    groups = {
        full_solid = 1, nature = 1, ironstone = 1, material_ironstone = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1 },
    tiles = { "aom_stone_ironstone_cobble.png" },
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:ironstone_cobble")
aom_tcraft.register_craft({
    output = "aom_stone:ironstone_cobble 80",
    items = {
        ["aom_items:iron_nugget"] = 1,
        ["aom_stone:cobble"] = 80,
    },
})

core.register_node("aom_stone:ironstone_brick", {
    description = S("Ironstone Brick"),
    groups = { full_solid = 1, ironstone = 1, material_ironstone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_ironstone_brick.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_stone:ironstone_brick")
aom_stone.register_two_way_craft("aom_stone:ironstone_cobble", "aom_stone:ironstone")
aom_stone.register_two_way_craft("aom_stone:ironstone_cobble", "aom_stone:ironstone_brick")

core.register_node("aom_stone:ironstone_brick_fine", {
    description = S("Fine Ironstone Brick"),
    groups = { full_solid = 1, ironstone = 1, material_ironstone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_ironstone_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_stone:ironstone_brick_fine")
aom_stone.register_two_way_craft("aom_stone:ironstone_cobble", "aom_stone:ironstone_brick_fine")


core.register_node("aom_stone:ironstone_brick_pillar", {
    description = S("Ironstone Brick Pillar"),
    groups = { full_solid = 1, ironstone = 1, material_ironstone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "aom_stone_ironstone_brick_pillar_top.png^[transformR90",
        "aom_stone_ironstone_brick_pillar_top.png",
        "aom_stone_ironstone_brick_pillar.png"},
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
aom_util.register_all_shapes("aom_stone:ironstone_brick_pillar")
aom_stone.register_two_way_craft("aom_stone:ironstone_cobble", "aom_stone:ironstone_brick_pillar")


core.register_node("aom_stone:ironstone_brick_ornate", {
    description = S("Ironstone Brick Ornate"),
    groups = { full_solid = 1, ironstone = 1, material_ironstone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_ironstone_brick_ornate.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_stone:ironstone_brick_ornate")
aom_stone.register_two_way_craft("aom_stone:ironstone_cobble", "aom_stone:ironstone_brick_ornate")


core.register_node("aom_stone:ironstone_brick_lamp", {
    description = S("Ironstone Brick Lamp"),
    groups = { full_solid = 1, ironstone = 1, material_ironstone_lamp = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = aom_util.node_light_unfck("aom_stone_ironstone_brick_lamp.png"),
    sounds = aom_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_stone:ironstone_brick_lamp")
aom_stone.register_craft({
    output = "aom_stone:ironstone_brick_lamp",
    items = {
        ["aom_stone:ironstone_cobble"] = 1,
        ["aom_lights:torch"] = 1,
    }
})


local function place_long_brick(itemstack, placer, pointed_thing)
    itemstack = ItemStack(itemstack)
    local name = itemstack:get_name()
    local def = core.registered_nodes[name]
    if core.get_node(pointed_thing.under).name == name then
        itemstack:set_name(def._alternate)
        itemstack = core.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
        itemstack:set_name(name)
    else
        itemstack = core.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
    end
    return itemstack
end

core.register_node("aom_stone:ironstone_brick_left", {
    description = S("Double Ironstone Brick (left)"),
    _tt_long_desc = S("The Left side of a long brick."),
    groups = { full_solid = 1, ironstone = 1, material_ironstone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "aom_stone_ironstone_brick_long_end_left.png",
        -- bottom
        "aom_stone_ironstone_brick_long_end_left.png",
        -- right / east
        "aom_stone_ironstone_brick_long_top.png",
        -- left / west
        "aom_stone_ironstone_brick_long_top.png",
        -- behind / north (facedir)
        "aom_stone_ironstone_brick_long_end_right.png",
        -- front / south (pointing at player)
        "aom_stone_ironstone_brick_long_end_left.png",
    },
    inventory_image = "aom_stone_ironstone_brick_long_inv.png^aom_stone_brick_long_inv_L.png",
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "aom_stone:ironstone_brick_right",
    on_place = place_long_brick,
})
aom_stone.register_two_way_craft("aom_stone:ironstone_cobble", "aom_stone:ironstone_brick_left")

core.register_node("aom_stone:ironstone_brick_right", {
    description = S("Double Ironstone Brick (right)"),
    _tt_long_desc = S("The right side of a long brick."),
    groups = { full_solid = 1,ironstone = 1,  material_ironstone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "aom_stone_ironstone_brick_long_end_right.png",
        -- bottom
        "aom_stone_ironstone_brick_long_end_right.png",
        -- right / east
        "aom_stone_ironstone_brick_long_top.png",
        -- left / west
        "aom_stone_ironstone_brick_long_top.png",
        -- behind / north (facedir)
        "aom_stone_ironstone_brick_long_end_left.png",
        -- front / south (pointing at player)
        "aom_stone_ironstone_brick_long_end_right.png",
    },
    inventory_image = "aom_stone_ironstone_brick_long_inv.png^aom_stone_brick_long_inv_R.png",
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "aom_stone:ironstone_brick_left",
    drop = "aom_stone:ironstone_brick_left",
    on_place = place_long_brick,
})
aom_stone.register_craft({output = "aom_stone:ironstone_brick_left", items = {["aom_stone:ironstone_brick_right"] = 1}})
aom_stone.register_craft({output = "aom_stone:ironstone_brick_right", items = {["aom_stone:ironstone_brick_left"] = 1}})
