local S = core.get_translator(core.get_current_modname())

core.register_node("aom_stone:stone", {
    description = S("Stone"),
    _tt_long_desc = S("What type of stone? Yes."),
    groups = {
        full_solid = 1, nature = 1, stone = 1, oddly_breakable_by_hand = 3, material_stone = 1,
        solid = 1, suffocates = 2, cracky = 1, silk_touchable = 1, natural_stone = 1 },
    tiles = { "aom_stone_stone.png" },
    drop = "aom_stone:cobble",
    sounds = aom_sounds.default_stone(),
    -- light_source = 10,
}) aom_util.register_all_shapes("aom_stone:stone")
aom_stone.register_two_way_craft("aom_stone:cobble", "aom_stone:stone")

core.register_node("aom_stone:sandstone", {
    description = S("Sandstone"),
    -- _tt_long_desc = S(""),
    groups = {
        full_solid = 1, nature = 1, sandstone = 1, oddly_breakable_by_hand = 3, material_sandstone = 1,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1 },
    tiles = { "aom_stone_sandstone.png" },
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:sandstone")

core.register_node("aom_stone:granite", {
    description = S("Granite"),
    groups = {
        full_solid = 1, nature = 1, granite = 1, oddly_breakable_by_hand = 3, material_stone = 1,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1 },
    tiles = { "aom_stone_granite.png" },
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:granite")

core.register_node("aom_stone:limestone", {
    description = S("Limestone"),
    groups = {
        full_solid = 1, nature = 1, limestone = 1, oddly_breakable_by_hand = 3, material_limestone = 1,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1 },
    tiles = { "aom_stone_limestone.png" },
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:limestone")

aom_stone.register_craft({
    output = "aom_stone:limestone_cobble",
    items = {
        ["aom_stone:limestone"] = 1
    },
    hide_if_not_craftable = true,
})

core.register_node("aom_stone:cobble", {
    description = S("Cobblestone"),
    groups = {
        full_solid = 1, nature = 1, cobble = 1, oddly_breakable_by_hand = 3, material_stone = 1,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1},
    tiles = { "aom_stone_cobble.png" },
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:cobble")


core.register_node("aom_stone:cobble_moss_1", {
    -- TL: stone variant
    description = S("Slightly Mossy Cobble"),
    groups = {
        full_solid = 1, nature = 1, oddly_breakable_by_hand = 3, material_stone_moss = 1,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, mossy_stone = 1, },
    tiles = { "aom_stone_cobble.png^aom_stone_cobble_moss_1.png" },
    drop = "aom_stone:cobble_moss_1",
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:cobble_moss_1")

core.register_node("aom_stone:cobble_moss_2", {
    -- TL: stone variant
    description = S("Very Mossy Cobble"),
    groups = {
        full_solid = 1, nature = 1, oddly_breakable_by_hand = 3, material_stone_moss = 1,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, mossy_stone = 1, },
    tiles = { "aom_stone_cobble.png^aom_stone_cobble_moss_2.png" },
    drop = "aom_stone:cobble_moss_2",
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:cobble_moss_2")

core.register_node("aom_stone:obsidian", {
    description = S("Obsidian"),
    groups = {
        full_solid = 1, nature = 1, obsidian = 1, oddly_breakable_by_hand = 4,
        cracky = 4, solid = 1, suffocates = 2,  material_obsidian = 1, },
    tiles = {"aom_obsidian.png"},
    sounds = aom_sounds.default_stone(),
}) aom_util.register_all_shapes("aom_stone:obsidian")

core.register_node("aom_stone:ignis_block", {
    description = S("Ignis Block"),
    groups = {
        full_solid = 1, nature = 1, ignis_block = 1, oddly_breakable_by_hand = 4,
        cracky = 4, solid = 1, suffocates = 2, },
    tiles = {"aom_stone_ignis_block.png"},
    sounds = aom_sounds.default_stone(),
})
aom_stone.register_craft({output = "aom_stone:ignis_block", items = {unobtainable = 1}})
aom_stone.register_craft({output = "aom_stone:ignis_block", items = {["aom_items:ignis"] = 1000}, tags = {"blocks"}})
aom_stone.register_craft({output = "aom_items:ignis 1000", items = {["aom_stone:ignis_block"] = 1}, tags = {"goods"}})


-- copy an existing node and make it an ore
function aom_stone.register_ore_node(in_node, oredef, flags)
    local name = in_node .. "_" .. oredef.ore_id .. "_ore"
    if flags and flags.blacklist and flags.blacklist[in_node] then return end
    if core.registered_nodes[name] then
        return
    end
    local def = table.copy(core.registered_nodes[in_node])
    local groups = def.groups
    def.groups = {
        solid = 1, full_solid = 1, nature = 1, oddly_breakable_by_hand = groups.oddly_breakable_by_hand,
        cracky = groups.cracky, magicky = groups.magicky, snappy = groups.snappy, suffocates = groups.suffocates,
        crumbly = groups.crumbly,
    }
    if flags and flags.groups then
        for k, v in pairs(groups) do
            def.groups[k] = v
        end
    end
    if not def then error(in_node.." is not a real node! Cannot make an ore from it!") end

    flags = flags or {}
    def.groups.natural_stone = nil
    -- TL: @1 is type of ore node ("Copper", "Ignis")
    def.description = S("@1 Ore", oredef.name)
    def.drop = oredef.drop
    def.groups.ore = 1
    def.light_source = math.max(def.glow or 0, oredef.glow or 0)
    if def.light_source > 0 and not def.paramtype then
        def.paramtype = "light"
    end

    for group, val in pairs(oredef.groups or {}) do
        def.groups[group] = val
    end
    for group, val in pairs(flags.groups or {}) do
        def.groups[group] = val
    end

    if type(def.tiles[1]) == "table" then
        error(in_node.." does not have simple tiles format.")
    else
        for i, texture in ipairs(def.tiles) do
            def.tiles[i] = texture .. "^" .. oredef.tiles_overlay
        end
    end

    core.register_node(name, def)
    aom_stone.register_craft({output = name, items = {unobtainable = 1}})
end

aom_stone.already_registered_ore_nodes = {}
aom_stone.registered_ore_types = {}
-- adds an ore type (e.g. "iron") which will have its ore added to all nodes that want ores placed in them
-- also registers nodes for "host nodes" that have already been defined, so that you don't get a race condition
function aom_stone.register_ore_type(ore_id, oredef)
    oredef.ore_id = ore_id
    aom_stone.registered_ore_types[ore_id] = oredef
    for node_name, flags in pairs(aom_stone.registered_ore_host_nodes) do
        aom_stone.register_ores_for_node(node_name, flags, true)
    end
end

aom_stone.registered_ore_host_nodes = {}
-- makes all nodes combinations for every ore currently defined
function aom_stone.register_ores_for_node(node_name, flags, skipdef)
    if not skipdef then
        aom_stone.registered_ore_host_nodes[node_name] = flags
    end

    for ore_id, oredef in pairs(aom_stone.registered_ore_types) do
        aom_stone.register_ore_node(node_name, oredef, flags)
    end
end


-- list each ore and its drops so you can batch register them later
aom_stone.register_ore_type("iron", {
    -- TL: ore node type ("@1 Ore")
    name = S("Iron"),
    tiles_overlay = "aom_iron_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"aom_items:iron_nugget"},
            },
        },
    },
})
aom_stone.register_ore_type("tin", {
    -- TL: ore node type ("@1 Ore")
    name = S("Tin"),
    tiles_overlay = "aom_tin_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"aom_items:tin_nugget"},
            },
        },
    },
})
aom_stone.register_ore_type("copper", {
    -- TL: ore node type ("@1 Ore")
    name = S("Copper"),
    tiles_overlay = "aom_copper_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"aom_items:copper_nugget"},
            },
        },
    },
})
aom_stone.register_ore_type("lapis", {
    -- TL: ore node type ("@1 Ore")
    name = S("Lapis Lazuli"),
    tiles_overlay = "aom_lapis_overlay.png",
    drop = {
        max_items = 7,
        items = {
            {
                items = {"aom_items:lapis_lazuli 2"},
            },
            {
                items = {"aom_items:lapis_lazuli 2"},
                rarity = 2
            },
            {
                items = {"aom_items:lapis_lazuli 3"},
                rarity = 6
            },
        },
    },
})
aom_stone.register_ore_type("diamond", {
    -- TL: ore node type ("@1 Ore")
    name = S("Diamond"),
    tiles_overlay = "aom_diamond_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"aom_items:diamond"},
            },
        },
    },
})
aom_stone.register_ore_type("coal", {
    -- TL: ore node type ("@1 Ore")
    name = S("Coal"),
    tiles_overlay = "aom_coal_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"aom_items:coal"},
            },
        },
    },
})
aom_stone.register_ore_type("gold", {
    -- TL: ore node type ("@1 Ore")
    name = S("Gold"),
    tiles_overlay = "aom_gold_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"aom_items:gold_nugget"},
            },
        },
    },
})
aom_stone.register_ore_type("ignis", {
    -- TL: ore node type ("@1 Ore")
    name = S("Ignis"),
    tiles_overlay = "aom_ignis_overlay.png",
    drop = {
        max_items = 5,
        items = {
            {
                items = {"aom_items:ignis 8"},
            },
            {
                items = {"aom_items:ignis 2"},
                rarity = 2,
            },
            {
                items = {"aom_items:ignis 4"},
                rarity = 2,
            },
            {
                items = {"aom_items:ignis 8"},
                rarity = 2,
            },
        },
    },
})

-- make all the ore nodes for these base nodes
aom_stone.register_ores_for_node("aom_stone:stone")
aom_stone.register_ores_for_node("aom_stone:limestone")
aom_stone.register_ores_for_node("aom_stone:sandstone")
aom_stone.register_ores_for_node("aom_stone:granite")


core.register_abm({
    label = "aom_stone:stone_to_ignis",
    nodenames = {"aom_stone:ignis_block"},
    interval = 20,
    chance = 100,
    action = function(pos, node, active_object_count, active_object_count_wider)
        local apos = vector.offset(pos, 0, 1, 0)
        local above = core.get_node(apos)
        if core.get_item_group(above.name, "stone") > 0 then
            local name = above.name .. "_ignis_ore"
            if not core.registered_nodes[name] then return end
            above.name = name
            core.set_node(apos, above)
        end
    end
})


core.register_node("aom_stone:bedrock", {
    description = S("Bedrock"),
    groups = {
        full_solid = 1, nature = 1, solid = 1, suffocates = 2, unobtainable = 1, immovable = 1, },
    tiles = { "aom_bedrock.png" },
    drop = "",
    sounds = aom_sounds.default_stone(),
    sunlight_propagates = true,
    diggable = false,
    on_dig = function(pos, node, digger)
        local name = (digger:is_player() and digger:get_player_name()) or dump(digger)
        core.log("\n\n[!!!] Bedrock was dug at " .. tostring(pos) .. " by " .. name .. "\n\n")
    end
})
aom_stone.register_craft({output = "aom_stone:bedrock", items = {unobtainable = 1}})


do
    local function reg_transmute(a, b, n, c)
        local ig = "aom_items:ignis"
        aom_stone.register_craft({
            output = b .. " " .. n, items = {[a] = n, [ig] = c},
            tags = {"transmute"},
        })
        aom_stone.register_craft({
            output = a .. " " .. n, items = {[b] = n, [ig] = c},
            hide_if_not_craftable = true, tags = {"transmute"},
        })
    end
    reg_transmute("aom_stone:cobble", "aom_stone:cobble_moss_1", 10, 1)
    reg_transmute("aom_stone:cobble", "aom_stone:cobble_moss_2", 10, 1)
    reg_transmute("aom_stone:cobble", "aom_stone:sandstone", 10, 1)
    reg_transmute("aom_stone:cobble", "aom_stone:granite", 10, 1)
    reg_transmute("aom_stone:cobble", "aom_stone:limestone", 10, 1)
    reg_transmute("aom_stone:cobble", "aom_soil:gravel", 10, 1)
    reg_transmute("aom_stone:cobble", "aom_soil:clay", 10, 3)
    reg_transmute("aom_stone:cobble", "aom_soil:dirt", 10, 3)
    reg_transmute("aom_stone:cobble", "aom_soil:sand", 10, 3)
    reg_transmute("aom_stone:cobble", "aom_stone:obsidian", 10, 5)
end
