local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

aom_admin_tools = {}
aom_admin_tools.has_aom_kits = core.get_modpath("aom_kits") ~= nil

function aom_admin_tools.debug_particle(pos, color, time, vel, size)
    -- do return end -- for debug purposes
    core.add_particle({
        size = size or 2,
        pos = pos,
        texture = "white.png^[colorize:"..(color or "#fff")..":255",
        velocity = vel or vector.new(0, 0, 0),
        expirationtime = time,
        glow = 14,
    })
end

dofile(mod_path .. "/items" .. "/fill.lua")
dofile(mod_path .. "/items" .. "/teleport_to.lua")
dofile(mod_path .. "/items" .. "/camera.lua")
dofile(mod_path .. "/items" .. "/util_tool.lua")
dofile(mod_path .. "/items" .. "/paint.lua")
dofile(mod_path .. "/items" .. "/ruler.lua")
