

local function xyz(param)
    return true
end

local function abc(param)
    return true
end



function  aom_cooking.cooker_offer_item(pos, itemstack)
    if not itemstack then
        return itemstack end
    itemstack = ItemStack(itemstack)
    local timer = core.get_node_timer(pos)
    if not timer:is_started() then
        timer:start(1.0)
    end
    local node = core.get_node(pos)
    local def = core.registered_nodes[node.name]
    local recipe = aom_cooking.get_recipe(itemstack:get_name(), def._cook_group(pos))
    if not recipe then
        return itemstack
    end

    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()

    local result = inv:add_item("input", ItemStack(itemstack:get_name()))
    if not result:is_empty() then
    else
        itemstack:take_item()
    end

    aom_cooking.update_infotext(pos)
    return itemstack
end


-- on_rightclick to take items out of the cooker
function aom_cooking.cooker_give_item(pos, node, clicker, itemstack, pointed_thing)
    return aom_cooking.cooker_offer_item(pos, itemstack)
end

-- on_punch
function aom_cooking.cooker_take_item(pos, node, clicker, itemstack, pointed_thing)
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()
    local output = inv:get_stack('output', 1)
    local input = inv:get_stack('input', 1)

    -- take stuff from the inv and give to player
    local clicker_inv = clicker:get_inventory()
    if not inv:is_empty('output') then
        local count = output:get_count()
        output = clicker_inv:add_item('main', output)
        inv:set_stack("output", 1, output)
        if count ~= output:get_count() then
            core.sound_play("aom_sounds_pickup", {
              gain = 0.2,
              pos = pos,
              max_hear_distance = 5,
            })
        end
        aom_cooking.update_infotext(pos)
        return itemstack
    elseif not inv:is_empty('input') then
        local count = input:get_count()
        input = clicker_inv:add_item('main', input)
        inv:set_stack("input", 1, input)
        if count ~= input:get_count() then
            core.sound_play("aom_sounds_pickup", {
              gain = 0.2,
              pos = pos,
              max_hear_distance = 5,
            })
        end
        aom_cooking.update_infotext(pos)
        return itemstack
    end
end


-- happens every second, set your on_timer to this
function aom_cooking.cooker_node_timer(pos, elapsed)
    local node = core.registered_nodes[core.get_node(pos).name]
    local cook_group
    if type(node._cook_group) == "function" then
        cook_group = node._cook_group(pos)
    else
        cook_group = node._cook_group
    end

    -- core.log("thinking")
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()


    -- don't cook if there's no heat
    if not cook_group then return end

    local has_cooked = false

    local itemstack = inv:get_stack("input", 1)
    if not itemstack then return false end
    local cooked

    local recipe = aom_cooking.get_recipe(itemstack:get_name(), cook_group)
    local timer_elapsed = meta:get_int("timer_elapsed") or 0
    timer_elapsed = timer_elapsed + 1

    if recipe then
        meta:set_int("timer_elapsed", timer_elapsed)
    end

    if (not recipe or not recipe.cook_time)
    or (timer_elapsed < recipe.cook_time) then
        return true
    else
        meta:set_int("timer_elapsed", 0)
    end

    if recipe.cook_time == -1 then
        itemstack, cooked = aom_cooking.cook(itemstack, cook_group, 999)
    else
        itemstack, cooked = aom_cooking.cook(itemstack, cook_group, 1)
    end

    if cooked and inv:room_for_item("output", cooked) then
        has_cooked = true
    end

    if has_cooked then
        inv:add_item("output", cooked)
        inv:set_stack("input", 1, itemstack)
        node._on_cook(pos, node)
        aom_cooking.update_infotext(pos)
    end
    return true
end


-- set your node on_construct to this
function aom_cooking.cooker_on_construct(pos)
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()
    inv:set_size('input', 1)
    inv:set_size('output', 1)
    -- aom_cooking.cooker_node_timer(pos, 0)
    local timer = core.get_node_timer(pos)
    if not timer:is_started() then
        timer:start(1.0)
    end
end

function aom_cooking.cooker_on_destruct(pos)
    if core.get_modpath("aom_inventory") ~= nil then
        local aom_inventory = rawget(_G, "aom_inventory")
        aom_inventory.drop_contents(pos)
    end
end
