local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

local pot_size = {
    type = "fixed",
    fixed = {-4/16, -8/16, -4/16, 4/16, -2/16, 4/16},
}

core.register_node("aom_cooking:pot", {
    description = S("Cooking Pot"),
    _tt_long_desc = S("Cooks food when placed above a lit fire.")..
        S("Cooks ores when placed above a lit furnace or lava."),
    _tt_how_to_use = S("[place] with a raw food item or ore in hand to cook") .. "\n" ..
        S("[dig] to take items"),
    groups = { item_cooking_pot = 1, solid = 1, furniture = 1, oddly_breakable_by_hand = 2,
        cracky = 1, iron = 1, cooker = 1, cooker_boil = 1 },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"aom_cooking_pot.png"},
    mesh = "aom_cooking_pot.b3d",
    sounds = (aom_sounds and aom_sounds.default_metal()) or {},
    collision_box = pot_size,
    selection_box = pot_size,
    _on_node_update = function(pos, cause, user, data)
        local timer = core.get_node_timer(pos)
        if not timer:is_started() then
                timer:start(1.0)
        end
    end,
    _on_cook = function(pos, node, cooked_item)
        local meta = core.get_meta(pos)
        local itemstack = meta:get_inventory():get_stack("input", 1)
        if itemstack:get_count() == 0 then
                core.sound_play("aom_cooking_finished_all", {
                gain = 0.5,
                pos = pos,
                max_hear_distance = 5,
                })
        end
        core.sound_play("aom_cooking_finished_boil", {
            gain = 0.9,
            pos = pos,
            max_hear_distance = 10,
        })
        for x=0, 3 do
            core.add_particle({
                pos = vector.offset(pos, math.random()-0.5, math.random()-0.5, math.random()-0.5),
                velocity = vector.new(0,math.random(),0),
                expirationtime = math.random() * 4,
                size = math.random() * 4,
                collisiondetection = false,
                vertical = false,
                texture = "aom_cooking_particle_finished_cooking.png^[colorize:#ffffff55:200",
                glow = 14,
            })
        end
    end,
    _cook_group = function(pos)
        local below = core.get_node(vector.offset(pos, 0, -1, 0))
        if core.get_item_group(below.name, "fire") ~= 0 then
            return "cooker_boil"
        elseif core.get_item_group(below.name, "melter") ~= 0
        or core.get_item_group(below.name, "lava") ~= 0 then
            return "cooker_crucible"
        else
            return nil
        end
    end,
    on_timer = aom_cooking.cooker_node_timer,
    on_construct = aom_cooking.cooker_on_construct,
    on_destruct = aom_cooking.cooker_on_destruct,
    on_punch = function(pos, node, clicker, itemstack, pointed_thing)
        aom_cooking.cooker_take_item(pos, node, clicker, itemstack, pointed_thing)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        return aom_cooking.cooker_give_item(pos, node, clicker, itemstack, pointed_thing)
    end,
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    _on_input_item = function(pos, itemstack)
        return aom_cooking.cooker_offer_item(pos, itemstack)
    end,
    _on_take_item = function(pos, itemstack, to_pos)
        aom_cooking.update_infotext(pos)
    end,
})




-- temporary crafting recipe
if true then
    local s = "aom_items:iron_nugget"
    core.register_craft({
        output = "aom_cooking:pot",
        recipe = {
            {s, "", s},
            {s, "", s},
            {s,  s, s},
        },
    })
end


