local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)


local function put_fire(itemstack, user, pointed_thing)
  if (not pointed_thing) or not pointed_thing.under then return end
  itemstack = ItemStack(itemstack)
  local to_node = core.registered_nodes[core.get_node(pointed_thing.under).name]
  if to_node and to_node.walkable and not to_node.buildable_to then
    local firenode = core.get_node(pointed_thing.above)
    if (core.registered_nodes[firenode.name] or {}).buildable_to then
      core.set_node(pointed_thing.above, {name="aom_fire:fire"})
      local def = core.registered_items[itemstack:get_name()]
      itemstack:add_wear(65536/(def and def._uses or 90))
    end
  end
  return itemstack
end

core.register_tool("aom_fire:flint_and_steel", {
  -- TL: sets thing on fire
  description = S("Flint and Steel"),
  _tt_long_desc = S("Lights fires."),
  _tt_how_to_use = S("Use: [place node]"),
  _tt_uses = 90,
  _uses = 90,
    inventory_image = "aom_flint_and_steel.png",
    stack_max = 1,
    groups = { usable = 1, starts_fires = 1 },
    on_place = put_fire,
})

core.register_craft({
  output = "aom_fire:flint_and_steel",
  type = "shapeless",
  recipe = {
    "aom_items:iron_bar", "aom_stone:cobble",
  },
})