local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

local uses

local enable_durability = core.settings:get("aom_tool_durability") == true

uses = 1024
core.register_tool("aom_hammer:iron_hammer", {
    description = S("Iron Hammer"),
    inventory_image = "aom_hammer_iron_hammer.png",
    _tt_long_desc = S("Replaces nodes quickly without having to dig and fill nodes back in."),
    _tt_how_to_use = S("[place] to paint node").."\n"..S("[dig] to pick node").."\n"..S("[aux1] to preserve param2 / rotation"),
    -- _tt_uses = uses,
    wield_scale = { x = 1, y = 1, z = 1.7 },
    tool_capabilities = {
        full_punch_interval = 2,
        groupcaps = {
            cracky = {
                maxlevel = 4,
                uses = ((not enable_durability) and 0) or uses,
            },
            crumbly = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            choppy = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            snappy = {
                maxlevel = 3,
                uses = ((not enable_durability) and 0) or uses,
            },
            dig_immediate = {
                maxlevel = 8,
                uses = ((not enable_durability) and 0) or uses,
            },
        },
        damage_groups = {
            blunt=5,
        },
    },
    groups = { hammer = 2 },
    on_place = aom_hammer.get_paint_node_from_pointed,
    on_use = aom_hammer.paint_node,
    _on_step = aom_hammer.paint_node_on_step,
})
if true then
    local m = "aom_items:stick"
    local b = "aom_items:iron_bar"
    core.register_craft({
        output = "aom_hammer:iron_hammer",
        recipe = {
        {b, m, b},
        {"",m,""},
        {"",m,""},
        },
    })
end
