---@diagnostic disable: undefined-doc-name
local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)


aom_machines = {}

aom_machines.has_aom_tcraft = (core.get_modpath("aom_tcraft") ~= nil)
aom_machines.has_aom_settings = (core.get_modpath("aom_settings") ~= nil)

aom_machines.cardinals_dir = {
	[tostring(vector.new(0, 0, 1))] = 0,
	[tostring(vector.new(1, 0, 0))] = 1,
	[tostring(vector.new(0, 0, -1))] = 2,
	[tostring(vector.new(-1, 0, 0))] = 3,
	[tostring(vector.new(0, 1, 0))] = 4,
	[tostring(vector.new(0, -1, 0))] = 5,
}
local __cardinal_rotate_filters = {
    function (v) return vector.new( v.x, v.y, v.z) end, -- 0
    function (v) return vector.new( v.z, v.y,-v.x) end, -- 90
    function (v) return vector.new(-v.x, v.y,-v.z) end, -- 180
    function (v) return vector.new(-v.z, v.y, v.x) end, -- 270
    function (v) return vector.new( v.x, v.z,-v.y) end, -- up
    function (v) return vector.new( v.x,-v.z, v.y) end, -- down
}
---Rotates clockwise 90d this many times, or up or down on r >= 4
---@param v vector
---@param r number
---@return unknown
function aom_machines.cardinal_rotate(v, r)
	return __cardinal_rotate_filters[math.round(r) % #__cardinal_rotate_filters + 1](v)
end

dofile(mod_path .. "/nodes/gates.lua")
dofile(mod_path .. "/nodes/gate_controllers.lua")
dofile(mod_path .. "/nodes/button.lua")
dofile(mod_path .. "/nodes/gear_lever.lua")
dofile(mod_path .. "/nodes/relay.lua")
dofile(mod_path .. "/nodes/node_placer.lua")
dofile(mod_path .. "/nodes/node_digger.lua")
dofile(mod_path .. "/nodes/node_detector.lua")
dofile(mod_path .. "/nodes/piston.lua")
dofile(mod_path .. "/nodes/indicator.lua")

dofile(mod_path .. "/items/wirecutter.lua")
dofile(mod_path .. "/items/welder.lua")

dofile(mod_path .. "/compat/aliases.lua")
