local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

core.register_tool("aom_machines:wirecutters", {
    description = S("Wirecutters"),
    _tt_color = 5,
    _tt_long_desc = S("Links and unlinks wire between nodes."),
    _tt_how_to_use = S("[place] to cut wires from a node") .. "\n" ..
        S("[dig] to start or end a link, where the start is the input"),
    inventory_image = "aom_wire_wirecutters.png",
    groups = { wirecutters = 1, wire = 1, },
    range = 6,
    on_use = aom_wire.wirecutters.on_use,
    on_place = aom_wire.wirecutters.on_place,
    on_secondary_use = aom_wire.wirecutters.on_secondary_use,
    _on_step = aom_wire.wirecutters.on_step,
    _on_select = aom_wire.wirecutters.on_select,
    _on_deselect = aom_wire.wirecutters.on_deselect,
})

if aom_machines.has_aom_tcraft then
    aom_tcraft.register_craft({
        output = "aom_machines:wirecutters",
        items = {
            ["aom_items:iron_bar"] = 5,
        },
    })
end
