local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

for i, n in ipairs({"on", "off"}) do
	local is_on = (n == "on")
	local other = "aom_machines:indicator_" .. ((is_on and "off") or "on")
	core.register_node("aom_machines:indicator_" .. n, {
		description = S("Indicator"),
		_tt_color = 3,
		_tt_long_desc = S("On wire signal, toggles on and off, preserving that state."),
		groups = { cracky = 1, oddly_breakable_by_hand = 2, solid = 1, full_solid = 1, mechanisms = 1, indicator = 1, },
		tiles = {
			"aom_machines_indicator_" .. n .. ".png",
		},
		sounds = aom_sounds.default_stone(),
		paramtype = "light",
		sunlight_propagates = true,
		paramtype2 = "facedir",
		drawtype = "normal",
		drop = "aom_machines:indicator_off",
		on_place = aom_util.rotate_and_place_against,
		on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
			core.swap_node(pos, {name = other})
			core.sound_play("aom_sounds_thud", {
				gain = 0.8, pitch = 1.0, pos = pos,
			})
		end,
		_on_wire_input = function(pos, user, source)
			core.swap_node(pos, {name = other})
		end,
	})
end

aom_tcraft.register_craft({
	output = "aom_machines:indicator_off",
	items = {
		["aom_stone:cobble"] = 1,
		["aom_items:copper_bar"] = 1,
	},
})

aom_tcraft.register_craft({
	output = "aom_machines:indicator_on", items = {["aom_machines:indicator_off"] = 1},
})
aom_tcraft.register_craft({
	output = "aom_machines:indicator_off", items = {["aom_machines:indicator_on"] = 1},
})
