local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

core.register_node("aom_machines:relay", {
	description = S("Wire Relay"),
	_tt_long_desc = S("Receives an input and gives it to its outputs."),
	_tt_color = 2,
	groups = {
		cracky = 2, oddly_breakable_by_hand = 3, solid = 1, full_solid = 1,
		mechanisms = 1, wire_input = 1, wire_output = 1, },
	tiles = {"aom_machines_relay.png"},
	sounds = aom_sounds.default_metal(),
	on_timer = function(pos, elapsed)
		aom_wire.activate_node_outputs(pos, nil)
	end,
	on_destruct = function(pos)
		local nt = core.get_node_timer(pos)
		if nt:is_started() then nt:stop() end
	end,
	_on_wire_input = function(pos, player, from_pos)
		local nt = core.get_node_timer(pos)
		if not nt:is_started() then
			nt:start(1)
			nt:set(1, 0.8)
		end
	end,
})

if aom_machines.has_aom_tcraft then
	aom_tcraft.register_craft({
		output = "aom_machines:relay",
		items = {
			["aom_items:iron_bar"] = 1,
			["aom_stone:stone_brick"] = 1,
		},
	})
end
