local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

aom_scrap = {}

aom_scrap.has_aom_inventory = (core.get_modpath("aom_inventory") ~= nil)
aom_scrap.has_aom_tcraft = (core.get_modpath("aom_tcraft") ~= nil)
aom_scrap.has_aom_settings = (core.get_modpath("aom_settings") ~= nil)

aom_scrap.get_setting = (aom_scrap.has_aom_settings and aom_settings.get_setting)
or function (player, settingname, default)
    return default
end

dofile(mod_path .. "/system.lua")
dofile(mod_path .. "/items.lua")

if aom_scrap.has_aom_inventory then
    dofile(mod_path .. "/aom_inventory_interface.lua")
end

if aom_scrap.has_aom_settings then
    aom_settings.register_setting("gameplay_trash_enabled", true, S("Enable trashing items"), "server")
end
