local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)


local function checkfix_reg(category, name)
    local cat = aom_scrap._register[category]
    if not cat then
        cat = {}
        aom_scrap._register[category] = cat
    end
    local list = name and cat[name]
    if name and not list then
        list = {}
        cat[name] = list
    end
    return cat, list
end

-- basic general register that allows you to reg anything you want
aom_scrap._register = {}
function aom_scrap.register(category, name, data)
    local cat, list = checkfix_reg(category, name)
    if cat._process ~= nil then
        data = cat._process(name, data) or data
    end
    table.insert(list, data)
end

-- causes registrations to use the callback as well as then storing them
function aom_scrap.register_process(category, callback)
    local cat, list = checkfix_reg(category)
    cat._process = callback
end

function aom_scrap.get_registered(category, tag)
    return (aom_scrap._register[category] and aom_scrap._register[category][tag]) or {}
end
