local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

aom_transit.transit_core = {}
local me = aom_transit.transit_core
me.pl = {} -- player data

--[[

[ ][ ][S][ ][ ]
[ ][ ][ ][ ][ ]
[S][ ][X][ ][S]
[ ][ ][ ][ ][ ]
[ ][ ][S][ ][ ]

]]

local structure_nodes = {
    [1] = {v = vector.new( 1, 0, 0), n = "aom_stone:obsidian"},
    [2] = {v = vector.new( 1, 0, 1), n = "aom_stone:obsidian"},
    [3] = {v = vector.new( 1, 0,-1), n = "aom_stone:obsidian"},
    [4] = {v = vector.new(-1, 0, 0), n = "aom_stone:obsidian"},
    [5] = {v = vector.new(-1, 0, 1), n = "aom_stone:obsidian"},
    [6] = {v = vector.new(-1, 0,-1), n = "aom_stone:obsidian"},
    [7] = {v = vector.new( 0, 0, 1), n = "aom_stone:obsidian"},
    [8] = {v = vector.new( 0, 0,-1), n = "aom_stone:obsidian"},
    -- ends and dais
    [9]  = {v = vector.new( 2, 0, 0), n = "aom_stone:obsidian"},
    [10] = {v = vector.new( 2, 1, 0), n = "aom_transit:obsidian_dais"},
    [11] = {v = vector.new( 0, 0, 2), n = "aom_stone:obsidian"},
    [12] = {v = vector.new( 0, 1, 2), n = "aom_transit:obsidian_dais"},
    [13] = {v = vector.new(-2, 0, 0), n = "aom_stone:obsidian"},
    [14] = {v = vector.new(-2, 1, 0), n = "aom_transit:obsidian_dais"},
    [15] = {v = vector.new( 0, 0,-2), n = "aom_stone:obsidian"},
    [16] = {v = vector.new( 0, 1,-2), n = "aom_transit:obsidian_dais"},
}

local function test_for_structure(pos)
    for i, d in pairs(structure_nodes) do
        if core.get_node(vector.add(pos, d.v)).name ~= d.n then
            return false
        end
    end
    return true
end

function me.make_links(pos, node, clicker, itemstack, pointed_thing, meta)
    local name = clicker:get_player_name()
    -- if the node you are teleporting to is destroyed, don't let you link it
    if (me.pl[name] ~= nil) and vector.equals(me.pl[name].dest, pointed_thing.under) then
        me.pl[name] = nil
    end
    if (me.pl[name] ~= nil) and (me.pl[name].dest ~= nil) then
        -- local p = clicker:get_pos()
        local p = me.pl[name].dest
        meta:set_float("destx", p.x)
        meta:set_float("desty", p.y)
        meta:set_float("destz", p.z)
        meta:set_string("has_link", "true")
        local to_meta = core.get_meta(me.pl[name].dest)
        to_meta:set_float("destx", pointed_thing.under.x)
        to_meta:set_float("desty", pointed_thing.under.y)
        to_meta:set_float("destz", pointed_thing.under.z)
        to_meta:set_string("has_link", "true")
        core.add_particle({
            pos = vector.offset(pointed_thing.under, 0, 0.6, 0),
            velocity = vector.new(0, 1, 0),
            size = 6,
            texture = "aom_transit_particle_link.png",
        })
        -- core.log("Link made to "..tostring(p).." from "..tostring(me.pl[name].dest))
        me.pl[name] = nil
    else
        me.pl[name] = {
            dest = vector.copy(pointed_thing.under),
        }
        -- core.log("Link started from "..tostring(pointed_thing.under))
        core.add_particle({
            pos = vector.offset(pointed_thing.under, 0, 0.6, 0),
            velocity = vector.new(0, 1, 0),
            size = 6,
            texture = "aom_transit_particle_link_start.png",
        })
    end
end

function me.teleport(pos, node, clicker, itemstack, pointed_thing, meta)
    local p = vector.new()
    p.x = meta:get_float("destx")
    p.y = meta:get_float("desty")
    p.z = meta:get_float("destz")
    core.load_area(p)
    if core.get_item_group(core.get_node(p).name, "aom_transit_core") == 0 then
        -- meta:set_string("has_link", "")
        -- core.log("Teleporting failed")
        core.add_particle({
            pos = vector.offset(pointed_thing.under, 0, 0.6, 0),
            velocity = vector.new(0, 1, 0),
            size = 6,
            texture = "aom_transit_particle_fail.png",
        })
        return false
    end
    core.add_particle({
        pos = vector.offset(pointed_thing.under, 0, 0.6, 0),
        velocity = vector.new(0, 1, 0),
        size = 6,
        texture = "aom_transit_particle_success.png",
    })
    p.y = p.y + 1
    if core.get_modpath("aom_weather") then
        aom_weather.force_stop_weather(clicker)
    end
    clicker:set_pos(p)
    -- core.log("Teleporting")
    return true
end

function me.on_rightclick(pos, node, clicker, itemstack, pointed_thing)
    if not clicker:is_player() then return itemstack end

    if test_for_structure(pos) == false then
        core.add_particle({
            pos = vector.offset(pointed_thing.under, 0, 0.6, 0),
            velocity = vector.new(0, 1, 0),
            size = 6,
            texture = "aom_transit_particle_fail.png",
        })
        return
    end
    local meta = core.get_meta(pointed_thing.under)
    if meta:get_string("has_link") == "true" then
        me.teleport(pos, node, clicker, itemstack, pointed_thing, meta)
    else
        me.make_links(pos, node, clicker, itemstack, pointed_thing, meta)
    end
end

core.register_node("aom_transit:transit_core", {
    description = ("Transit Core"),
    _tt_color = 6,
    groups = { full_solid = 1, item_transit_core = 1, oddly_breakable_by_hand = 3, furniture = 1,
        cracky = 3, solid = 1, suffocates = 2, aom_transit_core = 1, not_in_creative_inventory = 1, },
    tiles = {"aom_transit_core.png"},
    sounds = aom_sounds.default_stone(),
    light_source = 6,
    paramtype = "light",
    on_rightclick = me.on_rightclick,
})
if false then
    local m = "aom_underworld:mythril"
    local o = "aom_stone:obsidian"
    core.register_craft({
        output = "aom_transit:transit_core",
        recipe = {
            { m, o, m },
            { o, o, o },
            { m, o, m },
        },
    })
end
