local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)

-- biome decoration lists
dofile(mod_path .. "/mapgen" .. "/biome_decor" .. "/bridges.lua")
dofile(mod_path .. "/mapgen" .. "/biome_decor" .. "/coral.lua")
-- dofile(mod_path .. "/biome_decor" .. "/mythril_towers.lua")
dofile(mod_path .. "/mapgen" .. "/biome_decor" .. "/arlior_meadow.lua")
dofile(mod_path .. "/mapgen" .. "/biome_decor" .. "/arlior_growth.lua")

if core.get_modpath("aom_spawnnodes") ~= nil then
	core.register_decoration({
		deco_type = "simple",
		place_on = {
			"aom_underworld:lava_coral", "group:material_lava_rock",
		},
		sidelen = 4,
		noise_params = {
			offset = -2.5,
			scale = 3.5,
			spread = {x = 18, y = 8, z = 18},
			seed = 34562,
			octaves = 3,
			persist = 0.2,
			lacunarity = 2.00,
		},
		biomes = aom_mapgen.biome_groups.underworld or {"default"},
		y_max = aom_underworld.alt_max,
		y_min = aom_underworld.alt_min,
		decoration = "aom_spawnnodes:burning_ash",
		flags = "all_floors",
		_layer = 47,
	})
end
