local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

core.register_node('aom_underworld:arlior_brick', {
    description = S("Arlior Bricks"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_underworld:arlior_brick")
aom_underworld.register_two_way_craft("aom_underworld:arlior", "aom_underworld:arlior_brick")


core.register_node('aom_underworld:arlior_brick_fine', {
    description = S("Fine Arlior Bricks"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_underworld:arlior_brick_fine")
aom_underworld.register_two_way_craft("aom_underworld:arlior_brick", "aom_underworld:arlior_brick_fine")


core.register_node('aom_underworld:arlior_brick_ornate', {
    description = S("Ornate Arlior Bricks"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick_ornate_top.png", "aom_underworld_arlior_brick_ornate_top.png", "aom_underworld_arlior_brick_ornate.png", },
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
aom_util.register_all_shapes("aom_underworld:arlior_brick_ornate")
aom_underworld.register_two_way_craft("aom_underworld:arlior_brick", "aom_underworld:arlior_brick_ornate")


core.register_node('aom_underworld:arlior_brick_lamp', {
    description = S("Arlior Lamp"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior_lamp = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick_lamp.png"},
    sounds = aom_sounds.default_stone(),
    light_source = 10,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:arlior_brick_lamp")
aom_underworld.register_craft({
    output = "aom_underworld:arlior_brick_lamp 8",
    items = {
        ["aom_underworld:arlior_mushroom_blue"] = 1,
        ["aom_underworld:arlior_brick"] = 8,
    },
})
