local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

local arlior_box = {
    type = "fixed",
    fixed = {
      -5/16, -8/16, -5/16,
       5/16, -6/16,  5/16,
    }
}

aom_underworld.arlior = {}

core.register_node("aom_underworld:arlior_stem", {
    description = S("Arlior Stem"),
    _tt_color = 2,
    drawtype = "plantlike",
    waving = 1,
    paramtype = "light",
    paramtype2 = "meshoptions",
    param2 = 8,
    inventory_image = "aom_underworld_arlior_stem.png",
    wield_image = "aom_underworld_arlior_stem.png",
    walkable = false,
    is_ground_content = true,
    sunlight_propagates = true,
    selection_box = arlior_box,
    groups = { nature = 1, attached_node = 1,
        player_place_only = 1, arlior = 1, dig_immediate = 3, flora = 1, },
    tiles = {"aom_underworld_arlior_stem.png"},
    sounds = aom_sounds.default_plant(),
    -- on_place = function(itemstack, placer, pointed_thing)
    --     return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
    -- end,
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8 -- this makes it randomly offset horizontally
        core.swap_node(pos, node, true)
    end,
    -- light_source = 3,
})

core.register_node('aom_underworld:arlior_fola', {
    description = S("Arlior Fola"),
    _tt_color = 2,
    drawtype = "plantlike",
    waving = 1,
    paramtype = "light",
    paramtype2 = "meshoptions",
    param2 = 8,
    inventory_image = "aom_underworld_arlior_fola.png",
    wield_image = "aom_underworld_arlior_fola.png",
    walkable = false,
    is_ground_content = true,
    sunlight_propagates = true,
    selection_box = arlior_box,
    groups = { nature = 1, attached_node = 1,
        arlior = 1, dig_immediate = 3, flora = 1, player_place_only = 1, },
    tiles = {"aom_underworld_arlior_fola.png"},
    sounds = aom_sounds.default_plant(),
    -- on_place = function(itemstack, placer, pointed_thing)
    --     return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
    -- end,
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8 -- this makes it randomly offset horizontally
        core.swap_node(pos, node, true)
    end,
    -- light_source = 3,
})

core.register_abm({
    nodenames = {'aom_underworld:arlior_fola'},
    interval = 20.0,
    chance = 5,
    action = function(pos, node, active_object_count, active_object_count_wider)
        local node_below = core.get_node(vector.offset(pos, 0, -1, 0))
        local light = core.get_node_light(pos, 0.5)
        local daylight = core.get_natural_light(pos, 0.5)
        if light >= 10 and daylight <= 10 and node_below.name == "aom_underworld:arlior" then
            core.set_node(vector.offset(pos, 0, -1, 0), {name="aom_underworld:arlioran"})
        end
    end,
})



core.register_node('aom_underworld:arlior_mushroom_blue', {
    description = S("Blue Arlior Mushroom"),
    _tt_color = 3,
    drawtype = "plantlike",
    waving = 1,
    paramtype = "light",
    paramtype2 = "meshoptions",
    param2 = 8,
    inventory_image = "aom_underworld_arlior_mushroom_blue.png",
    wield_image = "aom_underworld_arlior_mushroom_blue.png",
    walkable = false,
    is_ground_content = true,
    sunlight_propagates = true,
    selection_box = arlior_box,
    groups = { nature = 1, attached_node = 1, dig_immediate = 3, flora = 1, },
    tiles = {"aom_underworld_arlior_mushroom_blue.png"},
    sounds = aom_sounds.default_plant(),
    -- on_place = function(itemstack, placer, pointed_thing)
    --     return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
    -- end,
    on_construct = function(pos)
        local node = core.get_node(pos)
        node.param2 = 8 -- this makes it randomly offset horizontally
        node.param1 = 238
        core.swap_node(pos, node, true)
    end,
    light_source = 4,
})

-- grow mushrooms
local mushroom_searchsize = vector.new(3,1,3)
core.register_abm({
    nodenames = {'aom_underworld:arlior_mushroom_blue'},
    interval = 20.0,
    chance = 10,
    action = function(pos, node, active_object_count, active_object_count_wider)
        aom_util.did_abm("crop")
        local light = core.get_node_light(pos, 0.5)
        local daylight = core.get_natural_light(pos, 0.5)
        if light < 9 or daylight > 9 then return false end

        local sp1 = vector.subtract(pos, mushroom_searchsize)
        local sp2 = vector.add(pos, mushroom_searchsize)

        local mushrooms = core.find_nodes_in_area(sp1, sp2, node.name)
        if #mushrooms > 10 then return end

        local nodes = core.find_nodes_in_area_under_air(sp1, sp2, "group:full_solid")
        local index = math.random(1, #nodes -1)
        if not nodes[index] then return end
        local place_pos = vector.offset(nodes[index], 0, 1, 0)
        if core.get_node(place_pos).name == "air" then
            if math.random() < 0.2 then
                core.set_node(place_pos, {name=node.name})
            else
                core.set_node(place_pos, {name="aom_underworld:arlior_fola"})
            end
        end
    end
})
