local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

core.register_node('aom_underworld:lava_brick', {
    description = S("Lava Bricks"),
    _tt_long_desc = S("Holding it burns, and yet it does not leave a mark."),
    groups = { full_solid = 1, material_lava_rock = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_brick")
aom_underworld.register_two_way_craft("aom_underworld:lava_rock", "aom_underworld:lava_brick")


core.register_node('aom_underworld:lava_brick_fine', {
    description = S("Fine Lava Bricks"),
    groups = { full_solid = 1, material_lava_rock = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_brick_fine")
aom_underworld.register_two_way_craft("aom_underworld:lava_rock", "aom_underworld:lava_brick_fine")


core.register_node('aom_underworld:lava_brick_ornate', {
    description = S("Ornate Lava Bricks"),
    groups = { full_solid = 1, material_lava_rock = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_ornate.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_brick_ornate")
aom_underworld.register_two_way_craft("aom_underworld:lava_rock", "aom_underworld:lava_brick_ornate")


core.register_node('aom_underworld:lava_brick_lamp', {
    description = S("Lava Brick Lamp"),
    groups = { full_solid = 1, material_lava_rock_lamp = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = aom_util.node_light_unfck("aom_underworld_lava_brick_lamp.png"),
    sounds = aom_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_brick_lamp")
aom_underworld.register_craft({
    output = "aom_underworld:lava_brick_lamp 8",
    items = {
        ["aom_underworld:lava_rock"] = 8,
        ["aom_underworld:glow_rock"] = 1,
    },
})


core.register_node('aom_underworld:lava_brick_pillar', {
    description = S("Lava Brick Pillar"),
    groups = { full_solid = 1, material_lava_rock = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_pillar_top.png", "aom_underworld_lava_brick_pillar_top.png", "aom_underworld_lava_brick_pillar.png", },
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_brick_pillar")
aom_underworld.register_two_way_craft("aom_underworld:lava_rock", "aom_underworld:lava_brick_pillar")


core.register_node('aom_underworld:lava_brick_coral', {
    description = S("Coral Covered Lava Bricks"),
    groups = { full_solid = 1, material_lava_rock = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_coral.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
aom_util.register_all_shapes("aom_underworld:lava_brick_coral")
aom_underworld.register_two_way_craft("aom_underworld:lava_rock", "aom_underworld:lava_brick_coral")
