

aom_player_init.inventory = {
    width = 10,
    height = 5,
}
aom_player_init.inventory.size = aom_player_init.inventory.width * aom_player_init.inventory.height

-- set the formspec size
aom_inventory.player.set_size(aom_player_init.inventory.width, aom_player_init.inventory.height)

function aom_player_init.safe_set_inventory_list_size(player, list_name, size)
    local inv = player:get_inventory()
    local old_size = inv:get_size(list_name)
    local difference = size - old_size
    local list
    if difference ~= 0 then
        list = inv:get_list(list_name)
        inv:set_size(list_name, size)
    end
    -- when shrinking the inventory
    if difference < 0 then
        for i = #list - math.abs(difference), #list do
            local stack = list[i]
            if stack and stack:get_count() > 0 then
                -- now that the inv is shrunk, try to add the stacks back again
                stack = inv:add_item(list_name, stack)
                if stack:get_count() > 0 then
                    local pos = player:get_pos()
                    pos = pos + vector.new(
                        (math.random()*2-1) * 0.2,
                        (math.random()) * 0.2 + 0.1,
                        (math.random()*2-1) * 0.2
                    )
                    core.add_item(pos, stack)
                end
            end
        end
    end
end

core.register_on_joinplayer(function(player)
    aom_player_init.safe_set_inventory_list_size(player, "main", aom_player_init.inventory.size)
    -- aom_player_init.safe_set_inventory_list_size(player, "main", 4)
    aom_player_init.safe_set_inventory_list_size(player, "armor", 4)
    aom_player_init.safe_set_inventory_list_size(player, "accessories", 1)
    -- remove builtin lists
	aom_player_init.safe_set_inventory_list_size(player, "craft", 0)
	aom_player_init.safe_set_inventory_list_size(player, "craftpreview", 0)
	aom_player_init.safe_set_inventory_list_size(player, "craftresult", 0)
    aom_inventory.player.init_hotbar(player)
    player:set_nametag_attributes({
        -- text = " ",
        color = "#ffffff50",
        bgcolor = "#ffffff00"
    })
    if core.settings:get_bool("enable_damage", true) then
        player:set_armor_groups({
            pierce=100,
            slash=100,
            blunt=100,
            magic=100,
            poison=100,
        })
    end
end)
