
function aom_vehicleapi.do_ship_controls(self, player, dtime)
    if ((not player) or not core.is_player(player)) then return false end
    if not self._last_ctrl then self._last_ctrl = {} end

    local ctrl = player:get_player_control()
    local steer = (ctrl.left and 1 or 0) + (ctrl.right and -1 or 0)
    local sail = 0
    -- (ctrl.down and -1 or 0) + (ctrl.up and 1 or 0)
    if ctrl.up and not self._last_ctrl.up then
        sail = 1
    elseif ctrl.down and not self._last_ctrl.down then
        sail = -1
    end

    local steer_response = self._aomv_steer_responsiveness or 1

    self._ctrl_sail = aom_vehicleapi.clamp(math.round((self._ctrl_sail or 0) + sail), -1, 3)
    self._ctrl_steer = aom_vehicleapi.clamp((self._ctrl_steer or 0) + steer * dtime * steer_response, -1, 1)

    if ctrl.sneak then
        if steer == 0 then self._ctrl_steer = 0 end
    end

    self._last_ctrl = ctrl

    return true
end

function aom_vehicleapi.do_airship_controls(self, player, dtime)
    if ((not player) or not core.is_player(player)) then return false end
    if not self._last_ctrl then self._last_ctrl = {} end

    local ctrl = player:get_player_control()
    local steer = (ctrl.left and 1 or 0) + (ctrl.right and -1 or 0)
    local climb = (ctrl.jump and 1 or 0) + (ctrl.sneak and -1 or 0)
    local sail = 0
    -- (ctrl.down and -1 or 0) + (ctrl.up and 1 or 0)
    if ctrl.up and not self._last_ctrl.up then
        sail = 1
    elseif ctrl.down and not self._last_ctrl.down then
        sail = -1
    end

    local steer_response = self._aomv_steer_responsiveness or 1
    local climb_response = self._aomv_climb_responsiveness or 3

    self._ctrl_sail = aom_vehicleapi.clamp(math.round((self._ctrl_sail or 0) + sail), -1, 3)
    self._ctrl_steer = aom_vehicleapi.clamp((self._ctrl_steer or 0) + steer * dtime * steer_response, -1, 1)
    self._ctrl_climb = (self._ctrl_climb) + climb * dtime * climb_response

    if ctrl.aux1 then
        if steer == 0 then self._ctrl_steer = 0 end
    end

    self._last_ctrl = ctrl

    return true
end
